/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.AttributeSet;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.LiteralAttribute;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.gen.script.Params;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;
import org.elasticsearch.xpack.sql.type.DataTypes;

public class Literal
extends NamedExpression {
    public static final Literal TRUE = Literal.of(Source.EMPTY, (Object)Boolean.TRUE);
    public static final Literal FALSE = Literal.of(Source.EMPTY, (Object)Boolean.FALSE);
    public static final Literal NULL = Literal.of(Source.EMPTY, null);
    private final Object value;
    private final DataType dataType;

    public Literal(Source source, Object value, DataType dataType) {
        this(source, null, value, dataType);
    }

    public Literal(Source source, String name, Object value, DataType dataType) {
        super(source, name == null ? source.text() : name, Collections.emptyList(), null);
        this.dataType = dataType;
        this.value = DataTypeConversion.convert(value, dataType);
    }

    @Override
    protected NodeInfo<? extends Literal> info() {
        return NodeInfo.create(this, Literal::new, this.value, this.dataType);
    }

    public Object value() {
        return this.value;
    }

    @Override
    public boolean foldable() {
        return true;
    }

    @Override
    public Nullability nullable() {
        return this.value == null ? Nullability.TRUE : Nullability.FALSE;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public boolean resolved() {
        return true;
    }

    @Override
    public Object fold() {
        return this.value;
    }

    @Override
    public Attribute toAttribute() {
        return new LiteralAttribute(this.source(), this.name(), null, this.nullable(), this.id(), false, this.dataType, this);
    }

    @Override
    public ScriptTemplate asScript() {
        return new ScriptTemplate(String.valueOf(this.value), Params.EMPTY, this.dataType);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    @Override
    public AttributeSet references() {
        return AttributeSet.EMPTY;
    }

    @Override
    protected Expression canonicalize() {
        String s = String.valueOf(this.value);
        return this.name().equals(s) ? this : Literal.of(this.source(), this.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.dataType});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Literal other = (Literal)obj;
        return Objects.equals(this.value, other.value) && Objects.equals((Object)this.dataType, (Object)other.dataType);
    }

    @Override
    public String toString() {
        String s = String.valueOf(this.value);
        return this.name().equals(s) ? s : this.name() + "=" + this.value;
    }

    public static Literal of(Source source, Object value) {
        if (value instanceof Literal) {
            return (Literal)value;
        }
        return new Literal(source, value, DataTypes.fromJava(value));
    }

    public static Literal of(Expression foldable) {
        return Literal.of((String)null, foldable);
    }

    public static Literal of(String name, Expression foldable) {
        if (!foldable.foldable()) {
            throw new SqlIllegalArgumentException("Foldable expression required for Literal creation; received unfoldable " + foldable);
        }
        if (foldable instanceof Literal) {
            Literal l = (Literal)foldable;
            if (name == null || l.name().equals(name)) {
                return l;
            }
        }
        Object fold = foldable.fold();
        if (name == null) {
            name = foldable instanceof NamedExpression ? ((NamedExpression)foldable).name() : String.valueOf(fold);
        }
        return new Literal(foldable.source(), name, fold, foldable.dataType());
    }

    public static Literal of(Expression source, Object value) {
        String name = source instanceof NamedExpression ? ((NamedExpression)source).name() : String.valueOf(value);
        return new Literal(source.source(), name, value, source.dataType());
    }
}

