/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.List;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.capabilities.Resolvable;
import org.elasticsearch.xpack.sql.capabilities.Resolvables;
import org.elasticsearch.xpack.sql.expression.AttributeSet;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.tree.Node;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class Expression
extends Node<Expression>
implements Resolvable {
    private TypeResolution lazyTypeResolution = null;
    private Boolean lazyChildrenResolved = null;
    private Expression lazyCanonical = null;
    private AttributeSet lazyReferences = null;

    public Expression(Source source, List<Expression> children) {
        super(source, children);
    }

    public boolean foldable() {
        return false;
    }

    public Object fold() {
        throw new SqlIllegalArgumentException("Should not fold expression");
    }

    public abstract Nullability nullable();

    public AttributeSet references() {
        if (this.lazyReferences == null) {
            this.lazyReferences = Expressions.references(this.children());
        }
        return this.lazyReferences;
    }

    public boolean childrenResolved() {
        if (this.lazyChildrenResolved == null) {
            this.lazyChildrenResolved = Resolvables.resolved(this.children());
        }
        return this.lazyChildrenResolved;
    }

    public final TypeResolution typeResolved() {
        if (this.lazyTypeResolution == null) {
            this.lazyTypeResolution = this.resolveType();
        }
        return this.lazyTypeResolution;
    }

    protected TypeResolution resolveType() {
        return TypeResolution.TYPE_RESOLVED;
    }

    public final Expression canonical() {
        if (this.lazyCanonical == null) {
            this.lazyCanonical = this.canonicalize();
        }
        return this.lazyCanonical;
    }

    protected Expression canonicalize() {
        return this;
    }

    public boolean semanticEquals(Expression other) {
        return this.canonical().equals(other.canonical());
    }

    public int semanticHash() {
        return this.canonical().hashCode();
    }

    @Override
    public boolean resolved() {
        return this.childrenResolved() && this.typeResolved().resolved();
    }

    public abstract DataType dataType();

    @Override
    public abstract int hashCode();

    @Override
    public String toString() {
        return this.nodeName() + "[" + this.propertiesToString(false) + "]";
    }

    public static class TypeResolution {
        private final boolean failed;
        private final String message;
        public static final TypeResolution TYPE_RESOLVED = new TypeResolution(false, "");

        public TypeResolution(String message) {
            this(true, message);
        }

        private TypeResolution(boolean unresolved, String message) {
            this.failed = unresolved;
            this.message = message;
        }

        public boolean unresolved() {
            return this.failed;
        }

        public boolean resolved() {
            return !this.failed;
        }

        public String message() {
            return this.message;
        }
    }
}

