/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.matrix.stats.InternalMatrixStats;
import org.elasticsearch.search.aggregations.matrix.stats.MatrixAggregationInspectionHelper;
import org.elasticsearch.search.aggregations.metrics.InternalAvg;
import org.elasticsearch.search.aggregations.metrics.InternalCardinality;
import org.elasticsearch.search.aggregations.metrics.InternalMax;
import org.elasticsearch.search.aggregations.metrics.InternalMin;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalStats;
import org.elasticsearch.search.aggregations.metrics.InternalSum;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.support.AggregationInspectionHelper;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.common.io.SqlStreamInput;
import org.elasticsearch.xpack.sql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class MetricAggExtractor
implements BucketExtractor {
    static final String NAME = "m";
    private final String name;
    private final String property;
    private final String innerKey;
    private final boolean isDateTimeBased;
    private final ZoneId zoneId;

    public MetricAggExtractor(String name, String property, String innerKey, ZoneId zoneId, boolean isDateTimeBased) {
        this.name = name;
        this.property = property;
        this.innerKey = innerKey;
        this.isDateTimeBased = isDateTimeBased;
        this.zoneId = zoneId;
    }

    MetricAggExtractor(StreamInput in) throws IOException {
        this.name = in.readString();
        this.property = in.readString();
        this.innerKey = in.readOptionalString();
        this.isDateTimeBased = in.readBoolean();
        this.zoneId = SqlStreamInput.asSqlStream(in).zoneId();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.property);
        out.writeOptionalString(this.innerKey);
        out.writeBoolean(this.isDateTimeBased);
    }

    String name() {
        return this.name;
    }

    String property() {
        return this.property;
    }

    String innerKey() {
        return this.innerKey;
    }

    ZoneId zoneId() {
        return this.zoneId;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        InternalAggregation agg = (InternalAggregation)bucket.getAggregations().get(this.name);
        if (agg == null) {
            throw new SqlIllegalArgumentException("Cannot find an aggregation named {}", this.name);
        }
        if (!MetricAggExtractor.containsValues(agg)) {
            return null;
        }
        if (agg instanceof InternalNumericMetricsAggregation.MultiValue) {
            return this.handleDateTime(((InternalNumericMetricsAggregation.MultiValue)agg).value(this.property));
        }
        if (agg instanceof InternalFilter) {
            return ((InternalFilter)agg).getDocCount();
        }
        Object v = agg.getProperty(this.property);
        return this.handleDateTime(this.innerKey != null && v instanceof Map ? ((Map)v).get(this.innerKey) : v);
    }

    private Object handleDateTime(Object object) {
        if (this.isDateTimeBased) {
            if (object == null) {
                return object;
            }
            if (object instanceof Number) {
                return DateUtils.asDateTime(((Number)object).longValue(), this.zoneId);
            }
            throw new SqlIllegalArgumentException("Invalid date key returned: {}", object);
        }
        return object;
    }

    private static boolean containsValues(InternalAggregation agg) {
        if (agg instanceof InternalStats) {
            return AggregationInspectionHelper.hasValue((InternalStats)((InternalStats)agg));
        }
        if (agg instanceof InternalMatrixStats) {
            return MatrixAggregationInspectionHelper.hasValue((InternalMatrixStats)((InternalMatrixStats)agg));
        }
        if (agg instanceof InternalMax) {
            return AggregationInspectionHelper.hasValue((InternalMax)((InternalMax)agg));
        }
        if (agg instanceof InternalMin) {
            return AggregationInspectionHelper.hasValue((InternalMin)((InternalMin)agg));
        }
        if (agg instanceof InternalAvg) {
            return AggregationInspectionHelper.hasValue((InternalAvg)((InternalAvg)agg));
        }
        if (agg instanceof InternalCardinality) {
            return AggregationInspectionHelper.hasValue((InternalCardinality)((InternalCardinality)agg));
        }
        if (agg instanceof InternalSum) {
            return AggregationInspectionHelper.hasValue((InternalSum)((InternalSum)agg));
        }
        if (agg instanceof InternalTDigestPercentileRanks) {
            return AggregationInspectionHelper.hasValue((InternalTDigestPercentileRanks)((InternalTDigestPercentileRanks)agg));
        }
        if (agg instanceof InternalTDigestPercentiles) {
            return AggregationInspectionHelper.hasValue((InternalTDigestPercentiles)((InternalTDigestPercentiles)agg));
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.property, this.innerKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MetricAggExtractor other = (MetricAggExtractor)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.property, other.property) && Objects.equals(this.innerKey, other.innerKey);
    }

    public String toString() {
        String i = this.innerKey != null ? "[" + this.innerKey + "]" : "";
        return "groupby>" + this.name + "." + this.property + i;
    }
}

