/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.sql.execution.search.SearchHitRowSet;
import org.elasticsearch.xpack.sql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.type.Schema;

public class ScrollCursor
implements Cursor {
    private final Logger log = LogManager.getLogger(this.getClass());
    public static final String NAME = "s";
    private final String scrollId;
    private final List<HitExtractor> extractors;
    private final BitSet mask;
    private final int limit;

    public ScrollCursor(String scrollId, List<HitExtractor> extractors, BitSet mask, int limit) {
        this.scrollId = scrollId;
        this.extractors = extractors;
        this.mask = mask;
        this.limit = limit;
    }

    public ScrollCursor(StreamInput in) throws IOException {
        this.scrollId = in.readString();
        this.limit = in.readVInt();
        this.extractors = in.readNamedWriteableList(HitExtractor.class);
        this.mask = BitSet.valueOf(in.readByteArray());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.scrollId);
        out.writeVInt(this.limit);
        out.writeNamedWriteableList(this.extractors);
        out.writeByteArray(this.mask.toByteArray());
    }

    public String getWriteableName() {
        return NAME;
    }

    String scrollId() {
        return this.scrollId;
    }

    BitSet mask() {
        return this.mask;
    }

    List<HitExtractor> extractors() {
        return this.extractors;
    }

    int limit() {
        return this.limit;
    }

    @Override
    public void nextPage(Configuration cfg, Client client, NamedWriteableRegistry registry, ActionListener<Cursor.Page> listener) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("About to execute scroll query {}", (Object)this.scrollId);
        }
        SearchScrollRequest request = new SearchScrollRequest(this.scrollId).scroll(cfg.pageTimeout());
        client.searchScroll(request, ActionListener.wrap(response -> ScrollCursor.handle(response, () -> new SearchHitRowSet(this.extractors, this.mask, this.limit, (SearchResponse)response), p -> listener.onResponse(p), p -> this.clear(cfg, client, (ActionListener<Boolean>)ActionListener.wrap(success -> listener.onResponse(p), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), Schema.EMPTY), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void clear(Configuration cfg, Client client, ActionListener<Boolean> listener) {
        ScrollCursor.cleanCursor(client, this.scrollId, (ActionListener<ClearScrollResponse>)ActionListener.wrap(clearScrollResponse -> listener.onResponse((Object)clearScrollResponse.isSucceeded()), arg_0 -> listener.onFailure(arg_0)));
    }

    static void handle(SearchResponse response, Supplier<SearchHitRowSet> makeRowHit, Consumer<Cursor.Page> onPage, Consumer<Cursor.Page> clearScroll, Schema schema) {
        SearchHit[] hits = response.getHits().getHits();
        if (hits.length > 0) {
            SearchHitRowSet rowSet = makeRowHit.get();
            Tuple<String, Integer> nextScrollData = rowSet.nextScrollData();
            if (nextScrollData == null) {
                clearScroll.accept(Cursor.Page.last(rowSet));
            } else {
                ScrollCursor next = new ScrollCursor((String)nextScrollData.v1(), rowSet.extractors(), rowSet.mask(), (Integer)nextScrollData.v2());
                onPage.accept(new Cursor.Page(rowSet, next));
            }
        } else {
            clearScroll.accept(Cursor.Page.last(Rows.empty(schema)));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ScrollCursor other = (ScrollCursor)obj;
        return Objects.equals(this.scrollId, other.scrollId) && Objects.equals(this.extractors, other.extractors) && Objects.equals(this.limit, other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.scrollId, this.extractors, this.limit);
    }

    public String toString() {
        return "cursor for scroll [" + this.scrollId + "]";
    }

    public static void cleanCursor(Client client, String scrollId, ActionListener<ClearScrollResponse> listener) {
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        client.clearScroll(clearScrollRequest, listener);
    }
}

