/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.sql.SqlFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.sql.plugin.SqlStatsAction;
import org.elasticsearch.xpack.sql.plugin.SqlStatsRequest;
import org.elasticsearch.xpack.sql.plugin.SqlStatsResponse;

public class SqlFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    private final Client client;

    @Inject
    public SqlFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState, Client client) {
        this.enabled = (Boolean)XPackSettings.SQL_ENABLED.get(settings);
        this.licenseState = licenseState;
        this.client = client;
    }

    public String name() {
        return "sql";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isSqlAllowed();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        if (this.enabled) {
            SqlStatsRequest request = new SqlStatsRequest();
            request.includeStats(true);
            this.client.execute((ActionType)SqlStatsAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> {
                List countersPerNode = r.getNodes().stream().map(SqlStatsResponse.NodeStatsResponse::getStats).filter(Objects::nonNull).collect(Collectors.toList());
                Counters mergedCounters = Counters.merge(countersPerNode);
                listener.onResponse((Object)new SqlFeatureSetUsage(this.available(), this.enabled(), mergedCounters.toNestedMap()));
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse((Object)new SqlFeatureSetUsage(this.available(), this.enabled(), Collections.emptyMap()));
        }
    }
}

