/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ArrayValueMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xpack.vectors.query.VectorDVIndexFieldData;

public class DenseVectorFieldMapper
extends FieldMapper
implements ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "dense_vector";
    public static short MAX_DIMS_COUNT = (short)1024;
    private static final byte INT_BYTES = 4;

    private DenseVectorFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.indexOptions() == IndexOptions.NONE);
    }

    protected DenseVectorFieldMapper clone() {
        return (DenseVectorFieldMapper)super.clone();
    }

    public DenseVectorFieldType fieldType() {
        return (DenseVectorFieldType)super.fieldType();
    }

    public void parse(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] can't be used in multi-fields");
        }
        int dims = this.fieldType().dims();
        byte[] buf = new byte[dims * 4];
        int offset = 0;
        int dim = 0;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_ARRAY) {
            if (dim++ >= dims) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] of doc [" + context.sourceToParse().id() + "] has exceeded the number of dimensions [" + dims + "] defined in mapping");
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, () -> ((XContentParser)context.parser()).getTokenLocation());
            float value = context.parser().floatValue(true);
            int intValue = Float.floatToIntBits(value);
            buf[offset++] = (byte)(intValue >> 24);
            buf[offset++] = (byte)(intValue >> 16);
            buf[offset++] = (byte)(intValue >> 8);
            buf[offset++] = (byte)intValue;
            token = context.parser().nextToken();
        }
        if (dim != dims) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] of doc [" + context.sourceToParse().id() + "] has number of dimensions [" + dim + "] less than defined in the mapping [" + dims + "]");
        }
        BinaryDocValuesField field = new BinaryDocValuesField(this.fieldType().name(), new BytesRef(buf, 0, offset));
        if (context.doc().getByKey((Object)this.fieldType().name()) != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't not support indexing multiple values for the same field in the same document");
        }
        context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)field);
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        builder.field("dims", this.fieldType().dims());
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class DenseVectorFieldType
    extends MappedFieldType {
        private int dims;

        public DenseVectorFieldType() {
        }

        protected DenseVectorFieldType(DenseVectorFieldType ref) {
            super((MappedFieldType)ref);
        }

        public DenseVectorFieldType clone() {
            return new DenseVectorFieldType(this);
        }

        int dims() {
            return this.dims;
        }

        void setDims(int dims) {
            this.dims = dims;
        }

        public String typeName() {
            return DenseVectorFieldMapper.CONTENT_TYPE;
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            throw new UnsupportedOperationException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support docvalue_fields or aggregations");
        }

        public Query existsQuery(QueryShardContext context) {
            return new DocValuesFieldExistsQuery(this.name());
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            return new VectorDVIndexFieldData.Builder(true);
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support queries");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Object dimsField = node.remove("dims");
            if (dimsField == null) {
                throw new MapperParsingException("The [dims] property must be specified for field [" + name + "].");
            }
            int dims = XContentMapValues.nodeIntegerValue((Object)dimsField);
            return builder.dims(dims);
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, DenseVectorFieldMapper> {
        private int dims = 0;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder dims(int dims) {
            if (dims > MAX_DIMS_COUNT || dims < 1) {
                throw new MapperParsingException("The number of dimensions for field [" + this.name + "] should be in the range [1, " + MAX_DIMS_COUNT + "]");
            }
            this.dims = dims;
            return this;
        }

        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            this.fieldType().setDims(this.dims);
        }

        public DenseVectorFieldType fieldType() {
            return (DenseVectorFieldType)super.fieldType();
        }

        public DenseVectorFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new DenseVectorFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build((FieldMapper.Builder)this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new DenseVectorFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

