/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.SuppressLoggerChecks;

public abstract class ESLogMessage
extends ParameterizedMessage {
    private static final JsonStringEncoder JSON_STRING_ENCODER = JsonStringEncoder.getInstance();
    private final Map<String, Object> fields;

    @SuppressLoggerChecks(reason="Safe as this is abstract class")
    public ESLogMessage(Map<String, Object> fields, String messagePattern, Object ... args) {
        super(messagePattern, args);
        this.fields = fields;
    }

    public static String escapeJson(String text) {
        byte[] sourceEscaped = JSON_STRING_ENCODER.quoteAsUTF8(text);
        return new String(sourceEscaped, Charset.defaultCharset());
    }

    public String getValueFor(String key) {
        Object value = this.fields.get(key);
        return value != null ? value.toString() : null;
    }

    public static String inQuotes(String s) {
        if (s == null) {
            return ESLogMessage.inQuotes("");
        }
        return "\"" + s + "\"";
    }

    public static String inQuotes(Object s) {
        if (s == null) {
            return ESLogMessage.inQuotes("");
        }
        return ESLogMessage.inQuotes(s.toString());
    }

    public static String asJsonArray(Stream<String> stream) {
        return "[" + stream.map(ESLogMessage::inQuotes).collect(Collectors.joining(", ")) + "]";
    }
}

