/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.flattened.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetDVOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DynamicKeyFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.xpack.flattened.mapper.FlatObjectFieldParser;
import org.elasticsearch.xpack.flattened.mapper.KeyedFlatObjectAtomicFieldData;

public final class FlatObjectFieldMapper
extends DynamicKeyFieldMapper {
    public static final String CONTENT_TYPE = "flattened";
    private static final String KEYED_FIELD_SUFFIX = "._keyed";
    private final FlatObjectFieldParser fieldParser;
    private int depthLimit;
    private int ignoreAbove;

    private FlatObjectFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, int ignoreAbove, int depthLimit, Settings indexSettings) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, FieldMapper.CopyTo.empty());
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.depthLimit = depthLimit;
        this.ignoreAbove = ignoreAbove;
        this.fieldParser = new FlatObjectFieldParser(fieldType.name(), this.keyedFieldName(), fieldType, depthLimit, ignoreAbove);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        this.ignoreAbove = ((FlatObjectFieldMapper)mergeWith).ignoreAbove;
    }

    protected FlatObjectFieldMapper clone() {
        return (FlatObjectFieldMapper)super.clone();
    }

    public RootFlatObjectFieldType fieldType() {
        return (RootFlatObjectFieldType)super.fieldType();
    }

    public KeyedFlatObjectFieldType keyedFieldType(String key) {
        return new KeyedFlatObjectFieldType(this.keyedFieldName(), key, this.fieldType());
    }

    public String keyedFieldName() {
        return this.fieldType.name() + KEYED_FIELD_SUFFIX;
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        if (this.fieldType.indexOptions() == IndexOptions.NONE && !this.fieldType.hasDocValues()) {
            context.parser().skipChildren();
            return;
        }
        XContentParser xContentParser = context.parser();
        fields.addAll(this.fieldParser.parse(xContentParser));
        if (!this.fieldType.hasDocValues()) {
            this.createFieldNamesField(context, fields);
        }
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.depthLimit != 20) {
            builder.field("depth_limit", this.depthLimit);
        }
        if (includeDefaults || this.ignoreAbove != Integer.MAX_VALUE) {
            builder.field("ignore_above", this.ignoreAbove);
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (includeDefaults || this.fieldType().splitQueriesOnWhitespace()) {
            builder.field("split_queries_on_whitespace", this.fieldType().splitQueriesOnWhitespace());
        }
    }

    public static final class RootFlatObjectFieldType
    extends StringFieldType {
        private boolean splitQueriesOnWhitespace;

        public RootFlatObjectFieldType() {
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        private RootFlatObjectFieldType(RootFlatObjectFieldType ref) {
            super((MappedFieldType)ref);
            this.splitQueriesOnWhitespace = ref.splitQueriesOnWhitespace;
        }

        public RootFlatObjectFieldType clone() {
            return new RootFlatObjectFieldType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RootFlatObjectFieldType that = (RootFlatObjectFieldType)((Object)o);
            return this.splitQueriesOnWhitespace == that.splitQueriesOnWhitespace;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.splitQueriesOnWhitespace);
        }

        public String typeName() {
            return FlatObjectFieldMapper.CONTENT_TYPE;
        }

        public boolean splitQueriesOnWhitespace() {
            return this.splitQueriesOnWhitespace;
        }

        public void setSplitQueriesOnWhitespace(boolean splitQueriesOnWhitespace) {
            this.checkIfFrozen();
            this.splitQueriesOnWhitespace = splitQueriesOnWhitespace;
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder();
        }
    }

    public static class KeyedFlatObjectFieldData
    implements IndexOrdinalsFieldData {
        private final String key;
        private final IndexOrdinalsFieldData delegate;

        private KeyedFlatObjectFieldData(String key, IndexOrdinalsFieldData delegate) {
            this.delegate = delegate;
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String getFieldName() {
            return this.delegate.getFieldName();
        }

        public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
            BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource((IndexFieldData)this, missingValue, sortMode, nested);
            return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
        }

        public void clear() {
            this.delegate.clear();
        }

        public AtomicOrdinalsFieldData load(LeafReaderContext context) {
            AtomicOrdinalsFieldData fieldData = (AtomicOrdinalsFieldData)this.delegate.load(context);
            return new KeyedFlatObjectAtomicFieldData(this.key, fieldData);
        }

        public AtomicOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
            AtomicOrdinalsFieldData fieldData = (AtomicOrdinalsFieldData)this.delegate.loadDirect(context);
            return new KeyedFlatObjectAtomicFieldData(this.key, fieldData);
        }

        public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
            IndexOrdinalsFieldData fieldData = this.delegate.loadGlobal(indexReader);
            return new KeyedFlatObjectFieldData(this.key, fieldData);
        }

        public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
            IndexOrdinalsFieldData fieldData = this.delegate.localGlobalDirect(indexReader);
            return new KeyedFlatObjectFieldData(this.key, fieldData);
        }

        public OrdinalMap getOrdinalMap() {
            throw new UnsupportedOperationException("The field data for the flat object field [" + this.delegate.getFieldName() + "] does not allow access to the underlying ordinal map.");
        }

        public boolean supportsGlobalOrdinalsMapping() {
            return false;
        }

        public Index index() {
            return this.delegate.index();
        }

        public static class Builder
        implements IndexFieldData.Builder {
            private final String key;

            Builder(String key) {
                this.key = key;
            }

            public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
                String fieldName = fieldType.name();
                SortedSetDVOrdinalsIndexFieldData delegate = new SortedSetDVOrdinalsIndexFieldData(indexSettings, cache, fieldName, breakerService, AbstractAtomicOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION);
                return new KeyedFlatObjectFieldData(this.key, (IndexOrdinalsFieldData)delegate);
            }
        }
    }

    public static final class KeyedFlatObjectFieldType
    extends StringFieldType {
        private final String key;
        private boolean splitQueriesOnWhitespace;

        public KeyedFlatObjectFieldType(String key) {
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.key = key;
        }

        public KeyedFlatObjectFieldType clone() {
            return new KeyedFlatObjectFieldType(this);
        }

        private KeyedFlatObjectFieldType(KeyedFlatObjectFieldType ref) {
            super((MappedFieldType)ref);
            this.key = ref.key;
            this.splitQueriesOnWhitespace = ref.splitQueriesOnWhitespace;
        }

        private KeyedFlatObjectFieldType(String name, String key, RootFlatObjectFieldType ref) {
            super((MappedFieldType)ref);
            this.setName(name);
            this.key = key;
            this.splitQueriesOnWhitespace = ref.splitQueriesOnWhitespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            KeyedFlatObjectFieldType that = (KeyedFlatObjectFieldType)((Object)o);
            return this.splitQueriesOnWhitespace == that.splitQueriesOnWhitespace;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.splitQueriesOnWhitespace);
        }

        public String typeName() {
            return FlatObjectFieldMapper.CONTENT_TYPE;
        }

        public String key() {
            return this.key;
        }

        public boolean splitQueriesOnWhitespace() {
            return this.splitQueriesOnWhitespace;
        }

        public void setSplitQueriesOnWhitespace(boolean splitQueriesOnWhitespace) {
            this.checkIfFrozen();
            this.splitQueriesOnWhitespace = splitQueriesOnWhitespace;
        }

        public Query existsQuery(QueryShardContext context) {
            Term term = new Term(this.name(), FlatObjectFieldParser.createKeyedValue(this.key, ""));
            return new PrefixQuery(term);
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            if (lowerTerm == null || upperTerm == null) {
                throw new IllegalArgumentException("[range] queries on keyed [flattened] fields must include both an upper and a lower bound.");
            }
            return super.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, context);
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
            throw new UnsupportedOperationException("[fuzzy] queries are not currently supported on keyed [flattened] fields.");
        }

        public Query regexpQuery(String value, int flags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            throw new UnsupportedOperationException("[regexp] queries are not currently supported on keyed [flattened] fields.");
        }

        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            throw new UnsupportedOperationException("[wildcard] queries are not currently supported on keyed [flattened] fields.");
        }

        public BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return null;
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            String keyedValue = FlatObjectFieldParser.createKeyedValue(this.key, stringValue);
            return new BytesRef((CharSequence)keyedValue);
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new KeyedFlatObjectFieldData.Builder(this.key);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseField((FieldMapper.Builder)builder, (String)name, node, (Mapper.TypeParser.ParserContext)parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("depth_limit")) {
                    builder.depthLimit(XContentMapValues.nodeIntegerValue((Object)propNode, (int)-1));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("eager_global_ordinals")) {
                    builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue((Object)propNode, (String)"eager_global_ordinals"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_above")) {
                    builder.ignoreAbove(XContentMapValues.nodeIntegerValue((Object)propNode, (int)-1));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("split_queries_on_whitespace")) continue;
                builder.splitQueriesOnWhitespace(XContentMapValues.nodeBooleanValue((Object)propNode, (String)"split_queries_on_whitespace"));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, FlatObjectFieldMapper> {
        private int depthLimit = 20;
        private int ignoreAbove = Integer.MAX_VALUE;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public RootFlatObjectFieldType fieldType() {
            return (RootFlatObjectFieldType)super.fieldType();
        }

        public Builder indexOptions(IndexOptions indexOptions) {
            if (indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) > 0) {
                throw new IllegalArgumentException("The [flattened] field does not support positions, got [index_options]=" + FlatObjectFieldMapper.indexOptionToString((IndexOptions)indexOptions));
            }
            return (Builder)super.indexOptions(indexOptions);
        }

        public Builder depthLimit(int depthLimit) {
            if (depthLimit < 0) {
                throw new IllegalArgumentException("[depth_limit] must be positive, got " + depthLimit);
            }
            this.depthLimit = depthLimit;
            return this;
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.fieldType().setEagerGlobalOrdinals(eagerGlobalOrdinals);
            return (Builder)this.builder;
        }

        public Builder ignoreAbove(int ignoreAbove) {
            if (ignoreAbove < 0) {
                throw new IllegalArgumentException("[ignore_above] must be positive, got " + ignoreAbove);
            }
            this.ignoreAbove = ignoreAbove;
            return this;
        }

        public Builder splitQueriesOnWhitespace(boolean splitQueriesOnWhitespace) {
            this.fieldType().setSplitQueriesOnWhitespace(splitQueriesOnWhitespace);
            return (Builder)this.builder;
        }

        public Builder addMultiField(Mapper.Builder<?, ?> mapperBuilder) {
            throw new UnsupportedOperationException("[fields] is not supported for [flattened] fields.");
        }

        public Builder copyTo(FieldMapper.CopyTo copyTo) {
            throw new UnsupportedOperationException("[copy_to] is not supported for [flattened] fields.");
        }

        public Builder store(boolean store) {
            throw new UnsupportedOperationException("[store] is not supported for [flattened] fields.");
        }

        public FlatObjectFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            if (this.fieldType().splitQueriesOnWhitespace()) {
                NamedAnalyzer whitespaceAnalyzer = new NamedAnalyzer("whitespace", AnalyzerScope.INDEX, (Analyzer)new WhitespaceAnalyzer());
                this.fieldType().setSearchAnalyzer(whitespaceAnalyzer);
            }
            return new FlatObjectFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreAbove, this.depthLimit, context.indexSettings());
        }
    }

    private static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new RootFlatObjectFieldType();
        public static final int DEPTH_LIMIT = 20;
        public static final int IGNORE_ABOVE = Integer.MAX_VALUE;

        private Defaults() {
        }

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

