/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.results;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetOverallBucketsAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestGetOverallBucketsAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetOverallBucketsAction.class));

    public RestGetOverallBucketsAction(RestController controller) {
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/overall_buckets", (RestHandler)this, RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/overall_buckets", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/overall_buckets", (RestHandler)this, RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/overall_buckets", deprecationLogger);
    }

    public String getName() {
        return "ml_get_overall_buckets_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetOverallBucketsAction.Request request;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            request = GetOverallBucketsAction.Request.parseRequest((String)jobId, (XContentParser)parser);
        } else {
            request = new GetOverallBucketsAction.Request(jobId);
            request.setTopN(restRequest.paramAsInt(GetOverallBucketsAction.Request.TOP_N.getPreferredName(), request.getTopN()));
            if (restRequest.hasParam(GetOverallBucketsAction.Request.BUCKET_SPAN.getPreferredName())) {
                request.setBucketSpan(restRequest.param(GetOverallBucketsAction.Request.BUCKET_SPAN.getPreferredName()));
            }
            request.setOverallScore(Double.parseDouble(restRequest.param(GetOverallBucketsAction.Request.OVERALL_SCORE.getPreferredName(), "0.0")));
            request.setExcludeInterim(restRequest.paramAsBoolean(GetOverallBucketsAction.Request.EXCLUDE_INTERIM.getPreferredName(), request.isExcludeInterim()));
            if (restRequest.hasParam(GetOverallBucketsAction.Request.START.getPreferredName())) {
                request.setStart(restRequest.param(GetOverallBucketsAction.Request.START.getPreferredName()));
            }
            if (restRequest.hasParam(GetOverallBucketsAction.Request.END.getPreferredName())) {
                request.setEnd(restRequest.param(GetOverallBucketsAction.Request.END.getPreferredName()));
            }
            request.setAllowNoJobs(restRequest.paramAsBoolean(GetOverallBucketsAction.Request.ALLOW_NO_JOBS.getPreferredName(), request.allowNoJobs()));
        }
        return channel -> client.execute((ActionType)GetOverallBucketsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

