/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.output;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.process.StateProcessor;

public class AutodetectStateProcessor
implements StateProcessor {
    private static final Logger LOGGER = LogManager.getLogger(AutodetectStateProcessor.class);
    private static final int READ_BUF_SIZE = 8192;
    private final Client client;
    private final String jobId;

    public AutodetectStateProcessor(Client client, String jobId) {
        this.client = client;
        this.jobId = jobId;
    }

    @Override
    public void process(InputStream in) throws IOException {
        CompositeBytesReference bytesToDate = null;
        ArrayList<BytesArray> newBlocks = new ArrayList<BytesArray>();
        byte[] readBuf = new byte[8192];
        int searchFrom = 0;
        int bytesRead = in.read(readBuf);
        while (bytesRead != -1) {
            BytesArray newBlock = new BytesArray(readBuf, 0, bytesRead);
            newBlocks.add(newBlock);
            if (AutodetectStateProcessor.findNextZeroByte((BytesReference)newBlock, 0, 0) == -1) {
                searchFrom += bytesRead;
            } else {
                CompositeBytesReference newBytes = new CompositeBytesReference(newBlocks.toArray(new BytesReference[0]));
                bytesToDate = bytesToDate == null ? newBytes : new CompositeBytesReference(new BytesReference[]{bytesToDate, newBytes});
                bytesToDate = this.splitAndPersist((BytesReference)bytesToDate, searchFrom);
                searchFrom = bytesToDate == null ? 0 : bytesToDate.length();
                newBlocks.clear();
            }
            readBuf = new byte[8192];
            bytesRead = in.read(readBuf);
        }
    }

    private BytesReference splitAndPersist(BytesReference bytesRef, int searchFrom) throws IOException {
        int nextZeroByte;
        int splitFrom = 0;
        while ((nextZeroByte = AutodetectStateProcessor.findNextZeroByte(bytesRef, searchFrom, splitFrom)) != -1) {
            if (nextZeroByte > splitFrom) {
                this.persist(bytesRef.slice(splitFrom, nextZeroByte - splitFrom));
            }
            splitFrom = nextZeroByte + 1;
        }
        if (splitFrom >= bytesRef.length()) {
            return null;
        }
        return bytesRef.slice(splitFrom, bytesRef.length() - splitFrom);
    }

    void persist(BytesReference bytes) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.add(bytes, AnomalyDetectorsIndex.jobStateIndexWriteAlias(), XContentType.JSON);
        if (bulkRequest.numberOfActions() > 0) {
            LOGGER.trace("[{}] Persisting job state document", (Object)this.jobId);
            try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
                this.client.bulk(bulkRequest).actionGet();
            }
        }
    }

    private static int findNextZeroByte(BytesReference bytesRef, int searchFrom, int splitFrom) {
        for (int i = Math.max(searchFrom, splitFrom); i < bytesRef.length(); ++i) {
            if (bytesRef.get(i) != 0) continue;
            return i;
        }
        return -1;
    }
}

