/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class JobDataDeleter {
    private static final Logger LOGGER = LogManager.getLogger(JobDataDeleter.class);
    private final Client client;
    private final String jobId;

    public JobDataDeleter(Client client, String jobId) {
        this.client = Objects.requireNonNull(client);
        this.jobId = Objects.requireNonNull(jobId);
    }

    public void deleteModelSnapshots(List<ModelSnapshot> modelSnapshots, ActionListener<BulkByScrollResponse> listener) {
        if (modelSnapshots.isEmpty()) {
            listener.onResponse((Object)new BulkByScrollResponse(TimeValue.ZERO, new BulkByScrollTask.Status(Collections.emptyList(), null), Collections.emptyList(), Collections.emptyList(), false));
            return;
        }
        String stateIndexName = AnomalyDetectorsIndex.jobStateIndexPattern();
        ArrayList<String> idsToDelete = new ArrayList<String>();
        HashSet<String> indices = new HashSet<String>();
        indices.add(stateIndexName);
        for (ModelSnapshot modelSnapshot : modelSnapshots) {
            idsToDelete.addAll(modelSnapshot.stateDocumentIds());
            idsToDelete.add(ModelSnapshot.documentId((ModelSnapshot)modelSnapshot));
            indices.add(AnomalyDetectorsIndex.jobResultsAliasedName((String)modelSnapshot.getJobId()));
        }
        DeleteByQueryRequest deleteByQueryRequest = ((DeleteByQueryRequest)new DeleteByQueryRequest(indices.toArray(new String[0])).setRefresh(true)).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)new IdsQueryBuilder().addIds(idsToDelete.toArray(new String[0])));
        try {
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void deleteResultsFromTime(long cutoffEpochMs, ActionListener<Boolean> listener) {
        DeleteByQueryHolder deleteByQueryHolder = new DeleteByQueryHolder(AnomalyDetectorsIndex.jobResultsAliasedName((String)this.jobId));
        deleteByQueryHolder.dbqRequest.setRefresh(true);
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)Result.RESULT_TYPE.getPreferredName())).filter((QueryBuilder)QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName()).gte((Object)cutoffEpochMs));
        deleteByQueryHolder.dbqRequest.setIndicesOptions(IndicesOptions.lenientExpandOpen());
        deleteByQueryHolder.dbqRequest.setQuery((QueryBuilder)query);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryHolder.dbqRequest, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)true), arg_0 -> listener.onFailure(arg_0)));
    }

    public void deleteInterimResults() {
        DeleteByQueryHolder deleteByQueryHolder = new DeleteByQueryHolder(AnomalyDetectorsIndex.jobResultsAliasedName((String)this.jobId));
        deleteByQueryHolder.dbqRequest.setRefresh(false);
        deleteByQueryHolder.dbqRequest.setIndicesOptions(IndicesOptions.lenientExpandOpen());
        TermQueryBuilder qb = QueryBuilders.termQuery((String)Result.IS_INTERIM.getPreferredName(), (boolean)true);
        deleteByQueryHolder.dbqRequest.setQuery((QueryBuilder)new ConstantScoreQueryBuilder((QueryBuilder)qb));
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryHolder.dbqRequest).get();
        }
        catch (Exception e) {
            LOGGER.error("[" + this.jobId + "] An error occurred while deleting interim results", (Throwable)e);
        }
    }

    public void deleteDatafeedTimingStats(ActionListener<BulkByScrollResponse> listener) {
        DeleteByQueryRequest deleteByQueryRequest = ((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)this.jobId)}).setRefresh(true)).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)new IdsQueryBuilder().addIds(new String[]{DatafeedTimingStats.documentId((String)this.jobId)}));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, listener);
    }

    private static class DeleteByQueryHolder {
        private final DeleteByQueryRequest dbqRequest = new DeleteByQueryRequest();

        private DeleteByQueryHolder(String index) {
            this.dbqRequest.indices(new String[]{index});
            this.dbqRequest.setSlices(0);
            this.dbqRequest.setAbortOnVersionConflict(false);
        }
    }
}

