/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process.results;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.dataframe.process.results.RowResults;

public class AnalyticsResult
implements ToXContentObject {
    public static final ParseField TYPE = new ParseField("analytics_result", new String[0]);
    public static final ParseField PROGRESS_PERCENT = new ParseField("progress_percent", new String[0]);
    public static final ConstructingObjectParser<AnalyticsResult, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), a -> new AnalyticsResult((RowResults)a[0], (Integer)a[1]));
    private final RowResults rowResults;
    private final Integer progressPercent;

    public AnalyticsResult(RowResults rowResults, Integer progressPercent) {
        this.rowResults = rowResults;
        this.progressPercent = progressPercent;
    }

    public RowResults getRowResults() {
        return this.rowResults;
    }

    public Integer getProgressPercent() {
        return this.progressPercent;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.rowResults != null) {
            builder.field(RowResults.TYPE.getPreferredName(), (ToXContent)this.rowResults);
        }
        if (this.progressPercent != null) {
            builder.field(PROGRESS_PERCENT.getPreferredName(), this.progressPercent);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AnalyticsResult that = (AnalyticsResult)other;
        return Objects.equals(this.rowResults, that.rowResults) && Objects.equals(this.progressPercent, that.progressPercent);
    }

    public int hashCode() {
        return Objects.hash(this.rowResults, this.progressPercent);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), RowResults.PARSER, RowResults.TYPE);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), PROGRESS_PERCENT);
    }
}

