/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsBuilder;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessConfig;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessFactory;
import org.elasticsearch.xpack.ml.dataframe.process.NativeAnalyticsProcess;
import org.elasticsearch.xpack.ml.dataframe.process.results.AnalyticsResult;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.ProcessPipes;
import org.elasticsearch.xpack.ml.utils.NamedPipeHelper;

public class NativeAnalyticsProcessFactory
implements AnalyticsProcessFactory<AnalyticsResult> {
    private static final Logger LOGGER = LogManager.getLogger(NativeAnalyticsProcessFactory.class);
    private static final NamedPipeHelper NAMED_PIPE_HELPER = new NamedPipeHelper();
    private final Environment env;
    private final NativeController nativeController;
    private volatile Duration processConnectTimeout;

    public NativeAnalyticsProcessFactory(Environment env, NativeController nativeController, ClusterService clusterService) {
        this.env = Objects.requireNonNull(env);
        this.nativeController = Objects.requireNonNull(nativeController);
        this.setProcessConnectTimeout((TimeValue)MachineLearning.PROCESS_CONNECT_TIMEOUT.get(env.settings()));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.PROCESS_CONNECT_TIMEOUT, this::setProcessConnectTimeout);
    }

    void setProcessConnectTimeout(TimeValue processConnectTimeout) {
        this.processConnectTimeout = Duration.ofMillis(processConnectTimeout.getMillis());
    }

    public NativeAnalyticsProcess createAnalyticsProcess(String jobId, AnalyticsProcessConfig analyticsProcessConfig, ExecutorService executorService, Consumer<String> onProcessCrash) {
        ArrayList<Path> filesToDelete = new ArrayList<Path>();
        ProcessPipes processPipes = new ProcessPipes(this.env, NAMED_PIPE_HELPER, "data_frame_analyzer", jobId, true, false, true, true, false, false);
        int numberOfFields = analyticsProcessConfig.cols() + 2;
        this.createNativeProcess(jobId, analyticsProcessConfig, filesToDelete, processPipes);
        NativeAnalyticsProcess analyticsProcess = new NativeAnalyticsProcess(jobId, processPipes.getLogStream().get(), processPipes.getProcessInStream().get(), processPipes.getProcessOutStream().get(), null, numberOfFields, filesToDelete, onProcessCrash, analyticsProcessConfig);
        try {
            analyticsProcess.start(executorService);
            return analyticsProcess;
        }
        catch (EsRejectedExecutionException e) {
            try {
                IOUtils.close((Closeable[])new Closeable[]{analyticsProcess});
            }
            catch (IOException ioe) {
                LOGGER.error("Can't close data frame analytics process", (Throwable)ioe);
            }
            throw e;
        }
    }

    private void createNativeProcess(String jobId, AnalyticsProcessConfig analyticsProcessConfig, List<Path> filesToDelete, ProcessPipes processPipes) {
        AnalyticsBuilder analyticsBuilder = new AnalyticsBuilder(() -> ((Environment)this.env).tmpFile(), this.nativeController, processPipes, analyticsProcessConfig, filesToDelete);
        try {
            analyticsBuilder.build();
            processPipes.connectStreams(this.processConnectTimeout);
        }
        catch (IOException e) {
            String msg = "Failed to launch data frame analytics process for job " + jobId;
            LOGGER.error(msg);
            throw ExceptionsHelper.serverError((String)msg, (Throwable)e);
        }
    }
}

