/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.extractor;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesAction;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.ml.datafeed.extractor.fields.ExtractedField;
import org.elasticsearch.xpack.ml.datafeed.extractor.fields.ExtractedFields;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractor;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorContext;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetector;

public class DataFrameDataExtractorFactory {
    private final Client client;
    private final String analyticsId;
    private final List<String> indices;
    private final ExtractedFields extractedFields;
    private final Map<String, String> headers;
    private final boolean includeRowsWithMissingValues;

    private DataFrameDataExtractorFactory(Client client, String analyticsId, List<String> indices, ExtractedFields extractedFields, Map<String, String> headers, boolean includeRowsWithMissingValues) {
        this.client = Objects.requireNonNull(client);
        this.analyticsId = Objects.requireNonNull(analyticsId);
        this.indices = Objects.requireNonNull(indices);
        this.extractedFields = Objects.requireNonNull(extractedFields);
        this.headers = headers;
        this.includeRowsWithMissingValues = includeRowsWithMissingValues;
    }

    public DataFrameDataExtractor newExtractor(boolean includeSource) {
        DataFrameDataExtractorContext context = new DataFrameDataExtractorContext(this.analyticsId, this.extractedFields, this.indices, this.createQuery(), 1000, this.headers, includeSource, this.includeRowsWithMissingValues);
        return new DataFrameDataExtractor(this.client, context);
    }

    private QueryBuilder createQuery() {
        return this.includeRowsWithMissingValues ? QueryBuilders.matchAllQuery() : this.allExtractedFieldsExistQuery();
    }

    private QueryBuilder allExtractedFieldsExistQuery() {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        for (ExtractedField field : this.extractedFields.getAllFields()) {
            query.filter((QueryBuilder)QueryBuilders.existsQuery((String)field.getName()));
        }
        return query;
    }

    public static void createForSourceIndices(Client client, String taskId, DataFrameAnalyticsConfig config, ActionListener<DataFrameDataExtractorFactory> listener) {
        DataFrameDataExtractorFactory.validateIndexAndExtractFields(client, config.getSource().getIndex(), config, null, false, (ActionListener<ExtractedFields>)ActionListener.wrap(extractedFields -> listener.onResponse((Object)new DataFrameDataExtractorFactory(client, taskId, Arrays.asList(config.getSource().getIndex()), (ExtractedFields)extractedFields, config.getHeaders(), config.getAnalysis().supportsMissingValues())), arg_0 -> listener.onFailure(arg_0)));
    }

    public static void createForDestinationIndex(Client client, DataFrameAnalyticsConfig config, boolean isTaskRestarting, ActionListener<DataFrameDataExtractorFactory> listener) {
        DataFrameDataExtractorFactory.validateIndexAndExtractFields(client, new String[]{config.getDest().getIndex()}, config, config.getDest().getResultsField(), isTaskRestarting, (ActionListener<ExtractedFields>)ActionListener.wrap(extractedFields -> listener.onResponse((Object)new DataFrameDataExtractorFactory(client, config.getId(), Arrays.asList(config.getDest().getIndex()), (ExtractedFields)extractedFields, config.getHeaders(), config.getAnalysis().supportsMissingValues())), arg_0 -> listener.onFailure(arg_0)));
    }

    public static void validateConfigAndSourceIndex(Client client, DataFrameAnalyticsConfig config, ActionListener<DataFrameAnalyticsConfig> listener) {
        DataFrameDataExtractorFactory.validateIndexAndExtractFields(client, config.getSource().getIndex(), config, config.getDest().getResultsField(), false, (ActionListener<ExtractedFields>)ActionListener.wrap(fields -> {
            config.getSource().getParsedQuery();
            listener.onResponse((Object)config);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static void validateIndexAndExtractFields(Client client, String[] index, DataFrameAnalyticsConfig config, String resultsField, boolean isTaskRestarting, ActionListener<ExtractedFields> listener) {
        AtomicInteger docValueFieldsLimitHolder = new AtomicInteger();
        ActionListener fieldCapabilitiesHandler = ActionListener.wrap(fieldCapabilitiesResponse -> listener.onResponse((Object)new ExtractedFieldsDetector(index, config, resultsField, isTaskRestarting, docValueFieldsLimitHolder.get(), (FieldCapabilitiesResponse)fieldCapabilitiesResponse).detect()), arg_0 -> listener.onFailure(arg_0));
        ActionListener docValueFieldsLimitListener = ActionListener.wrap(docValueFieldsLimit -> {
            docValueFieldsLimitHolder.set((int)docValueFieldsLimit);
            FieldCapabilitiesRequest fieldCapabilitiesRequest = new FieldCapabilitiesRequest();
            fieldCapabilitiesRequest.indices(index);
            fieldCapabilitiesRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
            fieldCapabilitiesRequest.fields(new String[]{"*"});
            ClientHelper.executeWithHeaders((Map)config.getHeaders(), (String)"ml", (Client)client, () -> {
                client.execute((ActionType)FieldCapabilitiesAction.INSTANCE, (ActionRequest)fieldCapabilitiesRequest, fieldCapabilitiesHandler);
                return null;
            });
        }, arg_0 -> listener.onFailure(arg_0));
        DataFrameDataExtractorFactory.getDocValueFieldsLimit(client, index, (ActionListener<Integer>)docValueFieldsLimitListener);
    }

    private static void getDocValueFieldsLimit(Client client, String[] index, ActionListener<Integer> docValueFieldsLimitListener) {
        ActionListener settingsListener = ActionListener.wrap(getSettingsResponse -> {
            Integer minDocValueFieldsLimit = Integer.MAX_VALUE;
            ImmutableOpenMap indexToSettings = getSettingsResponse.getIndexToSettings();
            for (ObjectObjectCursor indexSettings : indexToSettings) {
                Integer indexMaxDocValueFields = (Integer)IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING.get((Settings)indexSettings.value);
                if (indexMaxDocValueFields >= minDocValueFieldsLimit) continue;
                minDocValueFieldsLimit = indexMaxDocValueFields;
            }
            docValueFieldsLimitListener.onResponse((Object)minDocValueFieldsLimit);
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                docValueFieldsLimitListener.onFailure((Exception)new ResourceNotFoundException("cannot retrieve data because index " + ((IndexNotFoundException)e).getIndex() + " does not exist", new Object[0]));
            } else {
                docValueFieldsLimitListener.onFailure(e);
            }
        });
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest();
        getSettingsRequest.indices(index);
        getSettingsRequest.includeDefaults(true);
        getSettingsRequest.names(new String[]{IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING.getKey()});
        client.admin().indices().getSettings(getSettingsRequest, settingsListener);
    }
}

