/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class SourceDestValidator {
    private final ClusterState clusterState;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public SourceDestValidator(ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterState = Objects.requireNonNull(clusterState);
        this.indexNameExpressionResolver = Objects.requireNonNull(indexNameExpressionResolver);
    }

    public void check(DataFrameAnalyticsConfig config) {
        String[] sourceExpressions;
        Object[] sourceIndex = config.getSource().getIndex();
        String destIndex = config.getDest().getIndex();
        for (String sourceExpression : sourceExpressions = (String[])Arrays.stream(sourceIndex).map(index -> Strings.tokenizeToStringArray((String)index, (String)",")).flatMap(Arrays::stream).toArray(String[]::new)) {
            if (!Regex.simpleMatch((String)sourceExpression, (String)destIndex)) continue;
            throw ExceptionsHelper.badRequestException((String)"Destination index [{}] must not be included in source index [{}]", (Object[])new Object[]{destIndex, sourceExpression});
        }
        HashSet<String> concreteSourceIndexNames = new HashSet<String>(Arrays.asList(this.indexNameExpressionResolver.concreteIndexNames(this.clusterState, IndicesOptions.lenientExpandOpen(), sourceExpressions)));
        if (concreteSourceIndexNames.isEmpty()) {
            throw ExceptionsHelper.badRequestException((String)"No index matches source index {}", (Object[])new Object[]{Arrays.toString(sourceIndex)});
        }
        Object[] concreteDestIndexNames = this.indexNameExpressionResolver.concreteIndexNames(this.clusterState, IndicesOptions.lenientExpandOpen(), new String[]{destIndex});
        if (concreteDestIndexNames.length > 1) {
            throw ExceptionsHelper.badRequestException((String)"Destination index [{}] should match a single index; matches {}", (Object[])new Object[]{destIndex, Arrays.toString(concreteDestIndexNames)});
        }
        if (concreteDestIndexNames.length == 1 && concreteSourceIndexNames.contains(concreteDestIndexNames[0])) {
            throw ExceptionsHelper.badRequestException((String)"Destination index [{}], which is an alias for [{}], must not be included in source index {}", (Object[])new Object[]{destIndex, concreteDestIndexNames[0], Arrays.toString(sourceIndex)});
        }
    }
}

