/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsAction;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.ml.dataframe.MappingsMerger;

public final class DataFrameAnalyticsIndex {
    public static final String ID_COPY = "ml__id_copy";
    static final String CREATION_DATE_MILLIS = "creation_date_in_millis";
    static final String VERSION = "version";
    static final String CREATED = "created";
    static final String CREATED_BY = "created_by";
    static final String ANALYTICS = "analytics";
    private static final String PROPERTIES = "properties";
    private static final String META = "_meta";
    private static final String[] PRESERVED_SETTINGS = new String[]{"index.number_of_shards", "index.number_of_replicas"};

    private DataFrameAnalyticsIndex() {
    }

    public static void createDestinationIndex(Client client, Clock clock, DataFrameAnalyticsConfig analyticsConfig, ActionListener<CreateIndexResponse> listener) {
        ActionListener createIndexRequestListener = ActionListener.wrap(createIndexRequest -> ClientHelper.executeWithHeadersAsync((Map)analyticsConfig.getHeaders(), (String)"ml", (Client)client, (ActionType)CreateIndexAction.INSTANCE, (ActionRequest)createIndexRequest, (ActionListener)listener), arg_0 -> listener.onFailure(arg_0));
        DataFrameAnalyticsIndex.prepareCreateIndexRequest(client, clock, analyticsConfig, (ActionListener<CreateIndexRequest>)createIndexRequestListener);
    }

    private static void prepareCreateIndexRequest(Client client, Clock clock, DataFrameAnalyticsConfig config, ActionListener<CreateIndexRequest> listener) {
        AtomicReference settingsHolder = new AtomicReference();
        String[] sourceIndex = config.getSource().getIndex();
        ActionListener mappingsListener = ActionListener.wrap(mappings -> listener.onResponse((Object)DataFrameAnalyticsIndex.createIndexRequest(clock, config, (Settings)settingsHolder.get(), (ImmutableOpenMap<String, MappingMetaData>)mappings)), arg_0 -> listener.onFailure(arg_0));
        ActionListener settingsListener = ActionListener.wrap(settings -> {
            settingsHolder.set(settings);
            MappingsMerger.mergeMappings(client, config.getHeaders(), sourceIndex, (ActionListener<ImmutableOpenMap<String, MappingMetaData>>)mappingsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener getSettingsResponseListener = ActionListener.wrap(settingsResponse -> settingsListener.onResponse((Object)DataFrameAnalyticsIndex.settings(settingsResponse)), arg_0 -> listener.onFailure(arg_0));
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest();
        getSettingsRequest.indices(sourceIndex);
        getSettingsRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        getSettingsRequest.names(PRESERVED_SETTINGS);
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)client, (ActionType)GetSettingsAction.INSTANCE, (ActionRequest)getSettingsRequest, (ActionListener)getSettingsResponseListener);
    }

    private static CreateIndexRequest createIndexRequest(Clock clock, DataFrameAnalyticsConfig config, Settings settings, ImmutableOpenMap<String, MappingMetaData> mappings) {
        assert (mappings.size() == 1);
        String destinationIndex = config.getDest().getIndex();
        String type = (String)mappings.keysIt().next();
        Map mappingsAsMap = ((MappingMetaData)mappings.valuesIt().next()).sourceAsMap();
        DataFrameAnalyticsIndex.addProperties(mappingsAsMap);
        DataFrameAnalyticsIndex.addMetaData(mappingsAsMap, config.getId(), clock);
        return new CreateIndexRequest(destinationIndex, settings).mapping(type, mappingsAsMap);
    }

    private static Settings settings(GetSettingsResponse settingsResponse) {
        Integer maxNumberOfShards = DataFrameAnalyticsIndex.findMaxSettingValue(settingsResponse, "index.number_of_shards");
        Integer maxNumberOfReplicas = DataFrameAnalyticsIndex.findMaxSettingValue(settingsResponse, "index.number_of_replicas");
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put(IndexSortConfig.INDEX_SORT_FIELD_SETTING.getKey(), ID_COPY);
        settingsBuilder.put(IndexSortConfig.INDEX_SORT_ORDER_SETTING.getKey(), (Enum)SortOrder.ASC);
        if (maxNumberOfShards != null) {
            settingsBuilder.put("index.number_of_shards", maxNumberOfShards.intValue());
        }
        if (maxNumberOfReplicas != null) {
            settingsBuilder.put("index.number_of_replicas", maxNumberOfReplicas.intValue());
        }
        return settingsBuilder.build();
    }

    @Nullable
    private static Integer findMaxSettingValue(GetSettingsResponse settingsResponse, String settingKey) {
        Integer maxValue = null;
        Iterator settingsIterator = settingsResponse.getIndexToSettings().valuesIt();
        while (settingsIterator.hasNext()) {
            Settings settings = (Settings)settingsIterator.next();
            Integer indexValue = settings.getAsInt(settingKey, null);
            if (indexValue == null) continue;
            maxValue = maxValue == null ? indexValue : Math.max(indexValue, maxValue);
        }
        return maxValue;
    }

    private static void addProperties(Map<String, Object> mappingsAsMap) {
        Map properties = DataFrameAnalyticsIndex.getOrPutDefault(mappingsAsMap, PROPERTIES, HashMap::new);
        HashMap<String, String> idCopyMapping = new HashMap<String, String>();
        idCopyMapping.put("type", "keyword");
        properties.put(ID_COPY, idCopyMapping);
    }

    private static void addMetaData(Map<String, Object> mappingsAsMap, String analyticsId, Clock clock) {
        Map metadata = DataFrameAnalyticsIndex.getOrPutDefault(mappingsAsMap, META, HashMap::new);
        metadata.put(CREATION_DATE_MILLIS, clock.millis());
        metadata.put(CREATED_BY, "data-frame-analytics");
        HashMap<String, Version> versionMapping = new HashMap<String, Version>();
        versionMapping.put(CREATED, Version.CURRENT);
        metadata.put(VERSION, versionMapping);
        metadata.put(ANALYTICS, analyticsId);
    }

    private static <K, V> V getOrPutDefault(Map<K, Object> map, K key, Supplier<V> valueSupplier) {
        Object value = map.get(key);
        if (value == null) {
            value = valueSupplier.get();
            map.put(key, value);
        }
        return (V)value;
    }

    public static void updateMappingsToDestIndex(Client client, DataFrameAnalyticsConfig analyticsConfig, GetIndexResponse getIndexResponse, ActionListener<AcknowledgedResponse> listener) {
        assert (getIndexResponse.indices().length == 1);
        ImmutableOpenMap mappings = (ImmutableOpenMap)getIndexResponse.getMappings().get((Object)getIndexResponse.indices()[0]);
        String type = (String)mappings.keysIt().next();
        Map<String, Map<String, Map<String, String>>> addedMappings = Collections.singletonMap(PROPERTIES, Collections.singletonMap(ID_COPY, Collections.singletonMap("type", "keyword")));
        PutMappingRequest putMappingRequest = new PutMappingRequest(getIndexResponse.indices());
        putMappingRequest.type(type);
        putMappingRequest.source(addedMappings);
        ClientHelper.executeWithHeadersAsync((Map)analyticsConfig.getHeaders(), (String)"ml", (Client)client, (ActionType)PutMappingAction.INSTANCE, (ActionRequest)putMappingRequest, listener);
    }
}

