/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.job.JobNodeSelector;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportOpenJobAction
extends TransportMasterNodeAction<OpenJobAction.Request, AcknowledgedResponse> {
    static final PersistentTasksCustomMetaData.Assignment AWAITING_MIGRATION = new PersistentTasksCustomMetaData.Assignment(null, "job cannot be assigned until it has been migrated.");
    private final XPackLicenseState licenseState;
    private final PersistentTasksService persistentTasksService;
    private final JobConfigProvider jobConfigProvider;
    private final MlMemoryTracker memoryTracker;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;

    @Inject
    public TransportOpenJobAction(Settings settings, TransportService transportService, ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobConfigProvider jobConfigProvider, MlMemoryTracker memoryTracker) {
        super("cluster:admin/xpack/ml/job/open", transportService, clusterService, threadPool, actionFilters, OpenJobAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.persistentTasksService = persistentTasksService;
        this.jobConfigProvider = jobConfigProvider;
        this.memoryTracker = memoryTracker;
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
    }

    static void validate(String jobId, Job job) {
        if (job == null) {
            throw ExceptionsHelper.missingJobException((String)jobId);
        }
        if (job.isDeleting()) {
            throw ExceptionsHelper.conflictStatusException((String)("Cannot open job [" + jobId + "] because it is being deleted"), (Object[])new Object[0]);
        }
        if (job.getJobVersion() == null) {
            throw ExceptionsHelper.badRequestException((String)("Cannot open job [" + jobId + "] because jobs created prior to version 5.5 are not supported"), (Object[])new Object[0]);
        }
    }

    static String[] indicesOfInterest(String resultsIndex) {
        if (resultsIndex == null) {
            return new String[]{AnomalyDetectorsIndex.jobStateIndexPattern(), ".ml-meta", AnomalyDetectorsIndex.configIndexName()};
        }
        return new String[]{AnomalyDetectorsIndex.jobStateIndexPattern(), resultsIndex, ".ml-meta", AnomalyDetectorsIndex.configIndexName()};
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(String resultsWriteIndex, ClusterState clusterState) {
        IndexNameExpressionResolver resolver = new IndexNameExpressionResolver();
        String[] indices = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), TransportOpenJobAction.indicesOfInterest(resultsWriteIndex));
        ArrayList<String> unavailableIndices = new ArrayList<String>(indices.length);
        for (String index : indices) {
            IndexRoutingTable routingTable;
            if (!clusterState.metaData().hasIndex(index) || (routingTable = clusterState.getRoutingTable().index(index)) != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    private static boolean nodeSupportsModelSnapshotVersion(DiscoveryNode node, Job job) {
        if (job.getModelSnapshotId() == null || job.getModelSnapshotMinVersion() == null) {
            return true;
        }
        return node.getVersion().onOrAfter(job.getModelSnapshotMinVersion());
    }

    private static boolean jobHasRules(Job job) {
        return job.getAnalysisConfig().getDetectors().stream().anyMatch(d -> !d.getRules().isEmpty());
    }

    public static String nodeFilter(DiscoveryNode node, Job job) {
        String jobId = job.getId();
        if (!TransportOpenJobAction.nodeSupportsModelSnapshotVersion(node, job)) {
            return "Not opening job [" + jobId + "] on node [" + JobNodeSelector.nodeNameAndVersion(node) + "], because the job's model snapshot requires a node of version [" + job.getModelSnapshotMinVersion() + "] or higher";
        }
        if (!Job.getCompatibleJobTypes((Version)node.getVersion()).contains(job.getJobType())) {
            return "Not opening job [" + jobId + "] on node [" + JobNodeSelector.nodeNameAndVersion(node) + "], because this node does not support jobs of type [" + job.getJobType() + "]";
        }
        return null;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(OpenJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(OpenJobAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        if (this.migrationEligibilityCheck.jobIsEligibleForMigration(request.getJobParams().getJobId(), state)) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.configHasNotBeenMigrated((String)"open job", (String)request.getJobParams().getJobId())));
            return;
        }
        final OpenJobAction.JobParams jobParams = request.getJobParams();
        if (this.licenseState.isMachineLearningAllowed()) {
            final ActionListener clearJobFinishTime = ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    this.clearJobFinishedTime(jobParams.getJobId(), listener);
                } else {
                    listener.onResponse(response);
                }
            }, arg_0 -> listener.onFailure(arg_0));
            ActionListener<PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams>> waitForJobToStart = new ActionListener<PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams>>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> task) {
                    TransportOpenJobAction.this.waitForJobStarted(task.getId(), jobParams, (ActionListener<AcknowledgedResponse>)clearJobFinishTime);
                }

                public void onFailure(Exception e) {
                    if (e instanceof ResourceAlreadyExistsException) {
                        e = new ElasticsearchStatusException("Cannot open job [" + jobParams.getJobId() + "] because it has already been opened", RestStatus.CONFLICT, e, new Object[0]);
                    }
                    listener.onFailure((Exception)e);
                }
            };
            ActionListener memoryRequirementRefreshListener = ActionListener.wrap(arg_0 -> this.lambda$masterOperation$2(jobParams, (ActionListener)waitForJobToStart, arg_0), arg_0 -> listener.onFailure(arg_0));
            ActionListener getJobHandler = ActionListener.wrap(response -> this.memoryTracker.refreshAnomalyDetectorJobMemoryAndAllOthers(jobParams.getJobId(), (ActionListener<Long>)memoryRequirementRefreshListener), arg_0 -> listener.onFailure(arg_0));
            this.jobConfigProvider.getJob(jobParams.getJobId(), (ActionListener<Job.Builder>)ActionListener.wrap(builder -> {
                jobParams.setJob(builder.build());
                getJobHandler.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }

    private void waitForJobStarted(String taskId, final OpenJobAction.JobParams jobParams, final ActionListener<AcknowledgedResponse> listener) {
        final JobPredicate predicate = new JobPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(taskId, (Predicate)predicate, jobParams.getTimeout(), (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<OpenJobAction.JobParams>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> persistentTask) {
                if (predicate.exception != null) {
                    if (predicate.shouldCancel) {
                        TransportOpenJobAction.this.cancelJobStart((PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams>)persistentTask, predicate.exception, (ActionListener<AcknowledgedResponse>)listener);
                    } else {
                        listener.onFailure(predicate.exception);
                    }
                } else {
                    listener.onResponse((Object)new AcknowledgedResponse(predicate.opened));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)new ElasticsearchException("Opening job [" + jobParams.getJobId() + "] timed out after [" + timeout + "]", new Object[0]));
            }
        });
    }

    private void clearJobFinishedTime(String jobId, ActionListener<AcknowledgedResponse> listener) {
        JobUpdate update = new JobUpdate.Builder(jobId).setClearFinishTime(true).build();
        this.jobConfigProvider.updateJob(jobId, update, null, (ActionListener<Job>)ActionListener.wrap(job -> listener.onResponse((Object)new AcknowledgedResponse(true)), e -> {
            this.logger.error("[" + jobId + "] Failed to clear finished_time", (Throwable)e);
            listener.onResponse((Object)new AcknowledgedResponse(true));
        }));
    }

    private void cancelJobStart(final PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> persistentTask, final Exception exception, final ActionListener<AcknowledgedResponse> listener) {
        this.persistentTasksService.sendRemoveRequest(persistentTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                listener.onFailure(exception);
            }

            public void onFailure(Exception e) {
                TransportOpenJobAction.this.logger.error("[" + ((OpenJobAction.JobParams)persistentTask.getParams()).getJobId() + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                listener.onFailure(exception);
            }
        });
    }

    static ElasticsearchException makeNoSuitableNodesException(Logger logger, String jobId, String explanation) {
        String msg = "Could not open job because no suitable nodes were found, allocation explanation [" + explanation + "]";
        logger.warn("[{}] {}", (Object)jobId, (Object)msg);
        IllegalStateException detail = new IllegalStateException(msg);
        return new ElasticsearchStatusException("Could not open job because no ML nodes with sufficient capacity were found", RestStatus.TOO_MANY_REQUESTS, (Throwable)detail, new Object[0]);
    }

    static ElasticsearchException makeCurrentlyBeingUpgradedException(Logger logger, String jobId, String explanation) {
        String msg = "Cannot open jobs when upgrade mode is enabled";
        logger.warn("[{}] {}", (Object)jobId, (Object)msg);
        return new ElasticsearchStatusException(msg, RestStatus.TOO_MANY_REQUESTS, new Object[0]);
    }

    private /* synthetic */ void lambda$masterOperation$2(OpenJobAction.JobParams jobParams, ActionListener waitForJobToStart, Long mem) throws Exception {
        this.persistentTasksService.sendStartRequest(MlTasks.jobTaskId((String)jobParams.getJobId()), "xpack/ml/job", (PersistentTaskParams)jobParams, waitForJobToStart);
    }

    private class JobPredicate
    implements Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> {
        private volatile boolean opened;
        private volatile Exception exception;
        private volatile boolean shouldCancel;

        private JobPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
            JobState jobState = JobState.CLOSED;
            if (persistentTask != null) {
                JobTaskState jobTaskState = (JobTaskState)persistentTask.getState();
                jobState = jobTaskState == null ? JobState.OPENING : jobTaskState.getState();
                PersistentTasksCustomMetaData.Assignment assignment = persistentTask.getAssignment();
                if (assignment != null && assignment.equals((Object)JobNodeSelector.AWAITING_LAZY_ASSIGNMENT)) {
                    return true;
                }
                if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetaData.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                    OpenJobAction.JobParams params = (OpenJobAction.JobParams)persistentTask.getParams();
                    this.exception = TransportOpenJobAction.makeNoSuitableNodesException(TransportOpenJobAction.this.logger, params.getJobId(), assignment.getExplanation());
                    this.shouldCancel = true;
                    return true;
                }
            }
            switch (jobState) {
                case OPENING: 
                case CLOSED: {
                    return false;
                }
                case OPENED: {
                    this.opened = true;
                    return true;
                }
                case CLOSING: {
                    this.exception = ExceptionsHelper.conflictStatusException((String)("The job has been " + JobState.CLOSED + " while waiting to be " + JobState.OPENED), (Object[])new Object[0]);
                    return true;
                }
            }
            this.exception = ExceptionsHelper.serverError((String)("Unexpected job state [" + jobState + "] while waiting for job to be " + JobState.OPENED));
            return true;
        }
    }

    public static class JobTask
    extends AllocatedPersistentTask
    implements OpenJobAction.JobTaskMatcher {
        private static final Logger LOGGER = LogManager.getLogger(JobTask.class);
        private final String jobId;
        private volatile AutodetectProcessManager autodetectProcessManager;

        JobTask(String jobId, long id, String type, String action, TaskId parentTask, Map<String, String> headers) {
            super(id, type, action, "job-" + jobId, parentTask, headers);
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        protected void onCancelled() {
            String reason = this.getReasonCancelled();
            LOGGER.trace("[{}] Cancelling job task because: {}", (Object)this.jobId, (Object)reason);
            this.killJob(reason);
        }

        void killJob(String reason) {
            this.autodetectProcessManager.killProcess(this, false, reason);
        }

        void closeJob(String reason) {
            this.autodetectProcessManager.closeJob(this, false, reason);
        }
    }

    public static class OpenJobPersistentTasksExecutor
    extends PersistentTasksExecutor<OpenJobAction.JobParams> {
        private static final Logger logger = LogManager.getLogger(OpenJobPersistentTasksExecutor.class);
        private final AutodetectProcessManager autodetectProcessManager;
        private final MlMemoryTracker memoryTracker;
        private final Client client;
        private volatile int maxConcurrentJobAllocations;
        private volatile int maxMachineMemoryPercent;
        private volatile int maxLazyMLNodes;
        private volatile int maxOpenJobs;
        private volatile ClusterState clusterState;

        public OpenJobPersistentTasksExecutor(Settings settings, ClusterService clusterService, AutodetectProcessManager autodetectProcessManager, MlMemoryTracker memoryTracker, Client client) {
            super("xpack/ml/job", "ml_utility");
            this.autodetectProcessManager = Objects.requireNonNull(autodetectProcessManager);
            this.memoryTracker = Objects.requireNonNull(memoryTracker);
            this.client = Objects.requireNonNull(client);
            this.maxConcurrentJobAllocations = (Integer)MachineLearning.CONCURRENT_JOB_ALLOCATIONS.get(settings);
            this.maxMachineMemoryPercent = (Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings);
            this.maxLazyMLNodes = (Integer)MachineLearning.MAX_LAZY_ML_NODES.get(settings);
            this.maxOpenJobs = (Integer)MachineLearning.MAX_OPEN_JOBS_PER_NODE.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.CONCURRENT_JOB_ALLOCATIONS, this::setMaxConcurrentJobAllocations);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_MACHINE_MEMORY_PERCENT, this::setMaxMachineMemoryPercent);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_LAZY_ML_NODES, this::setMaxLazyMLNodes);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_OPEN_JOBS_PER_NODE, this::setMaxOpenJobs);
            clusterService.addListener(event -> {
                this.clusterState = event.state();
            });
        }

        public PersistentTasksCustomMetaData.Assignment getAssignment(OpenJobAction.JobParams params, ClusterState clusterState) {
            boolean scheduledRefresh;
            if (params.getJob() == null) {
                return AWAITING_MIGRATION;
            }
            if (MlMetadata.getMlMetadata((ClusterState)clusterState).isUpgradeMode()) {
                return MlTasks.AWAITING_UPGRADE;
            }
            String jobId = params.getJobId();
            String resultsWriteAlias = AnomalyDetectorsIndex.resultsWriteAlias((String)jobId);
            List<String> unavailableIndices = TransportOpenJobAction.verifyIndicesPrimaryShardsAreActive(resultsWriteAlias, clusterState);
            if (unavailableIndices.size() != 0) {
                String reason = "Not opening job [" + jobId + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
                logger.debug(reason);
                return new PersistentTasksCustomMetaData.Assignment(null, reason);
            }
            boolean isMemoryTrackerRecentlyRefreshed = this.memoryTracker.isRecentlyRefreshed();
            if (!isMemoryTrackerRecentlyRefreshed && (scheduledRefresh = this.memoryTracker.asyncRefresh())) {
                String reason = "Not opening job [" + jobId + "] because job memory requirements are stale - refresh requested";
                logger.debug(reason);
                return new PersistentTasksCustomMetaData.Assignment(null, reason);
            }
            Job job = params.getJob();
            JobNodeSelector jobNodeSelector = new JobNodeSelector(clusterState, jobId, "xpack/ml/job", this.memoryTracker, this.maxLazyMLNodes, node -> TransportOpenJobAction.nodeFilter(node, job));
            return jobNodeSelector.selectNode(this.maxOpenJobs, this.maxConcurrentJobAllocations, this.maxMachineMemoryPercent, isMemoryTrackerRecentlyRefreshed);
        }

        public void validate(OpenJobAction.JobParams params, ClusterState clusterState) {
            TransportOpenJobAction.validate(params.getJobId(), params.getJob());
            PersistentTasksCustomMetaData.Assignment assignment = this.getAssignment(params, clusterState);
            if (assignment.equals((Object)MlTasks.AWAITING_UPGRADE)) {
                throw TransportOpenJobAction.makeCurrentlyBeingUpgradedException(logger, params.getJobId(), assignment.getExplanation());
            }
            if (assignment.getExecutorNode() == null && !assignment.equals((Object)JobNodeSelector.AWAITING_LAZY_ASSIGNMENT)) {
                throw TransportOpenJobAction.makeNoSuitableNodesException(logger, params.getJobId(), assignment.getExplanation());
            }
        }

        protected void nodeOperation(AllocatedPersistentTask task, OpenJobAction.JobParams params, PersistentTaskState state) {
            JobTask jobTask = (JobTask)task;
            jobTask.autodetectProcessManager = this.autodetectProcessManager;
            JobTaskState jobTaskState = (JobTaskState)state;
            if (jobTaskState != null && jobTaskState.getState().isAnyOf(new JobState[]{JobState.FAILED, JobState.CLOSING})) {
                return;
            }
            String jobId = jobTask.getJobId();
            this.autodetectProcessManager.openJob(jobTask, this.clusterState, (e2, shouldFinalizeJob) -> {
                if (e2 == null) {
                    if (shouldFinalizeJob.booleanValue()) {
                        FinalizeJobExecutionAction.Request finalizeRequest = new FinalizeJobExecutionAction.Request(new String[]{jobId});
                        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)FinalizeJobExecutionAction.INSTANCE, (ActionRequest)finalizeRequest, (ActionListener)ActionListener.wrap(response -> task.markAsCompleted(), e -> logger.error("error finalizing job [" + jobId + "]", (Throwable)e)));
                    } else {
                        task.markAsCompleted();
                    }
                } else {
                    task.markAsFailed(e2);
                }
            });
        }

        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> persistentTask, Map<String, String> headers) {
            return new JobTask(((OpenJobAction.JobParams)persistentTask.getParams()).getJobId(), id, type, action, parentTaskId, headers);
        }

        void setMaxConcurrentJobAllocations(int maxConcurrentJobAllocations) {
            this.maxConcurrentJobAllocations = maxConcurrentJobAllocations;
        }

        void setMaxMachineMemoryPercent(int maxMachineMemoryPercent) {
            this.maxMachineMemoryPercent = maxMachineMemoryPercent;
        }

        void setMaxLazyMLNodes(int maxLazyMLNodes) {
            this.maxLazyMLNodes = maxLazyMLNodes;
        }

        void setMaxOpenJobs(int maxOpenJobs) {
            this.maxOpenJobs = maxOpenJobs;
        }
    }
}

