/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.MlInfoAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.NativeControllerHolder;

public class TransportMlInfoAction
extends HandledTransportAction<MlInfoAction.Request, MlInfoAction.Response> {
    private final ClusterService clusterService;
    private final Map<String, Object> nativeCodeInfo;

    @Inject
    public TransportMlInfoAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Environment env) {
        super("cluster:monitor/xpack/ml/info/get", transportService, actionFilters, MlInfoAction.Request::new);
        this.clusterService = clusterService;
        try {
            NativeController nativeController = NativeControllerHolder.getNativeController(clusterService.getNodeName(), env);
            this.nativeCodeInfo = nativeController != null ? nativeController.getNativeCodeInfo() : Collections.emptyMap();
        }
        catch (IOException e) {
            throw new IllegalStateException("native controller failed to load", e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Could not get native code info from native controller", e);
        }
    }

    protected void doExecute(Task task, MlInfoAction.Request request, ActionListener<MlInfoAction.Response> listener) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("defaults", this.defaults());
        info.put("limits", this.limits());
        info.put("native_code", this.nativeCodeInfo);
        info.put(MlMetadata.UPGRADE_MODE.getPreferredName(), this.upgradeMode());
        listener.onResponse((Object)new MlInfoAction.Response(info));
    }

    private Map<String, Object> defaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("anomaly_detectors", this.anomalyDetectorsDefaults());
        defaults.put("datafeeds", this.datafeedsDefaults());
        return defaults;
    }

    private boolean upgradeMode() {
        return MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).isUpgradeMode();
    }

    private Map<String, Object> anomalyDetectorsDefaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put(AnalysisLimits.MODEL_MEMORY_LIMIT.getPreferredName(), this.defaultModelMemoryLimit());
        defaults.put(AnalysisLimits.CATEGORIZATION_EXAMPLES_LIMIT.getPreferredName(), 4L);
        defaults.put(Job.MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), 1L);
        return defaults;
    }

    private ByteSizeValue defaultModelMemoryLimit() {
        ByteSizeValue defaultLimit = new ByteSizeValue(1024L, ByteSizeUnit.MB);
        ByteSizeValue maxModelMemoryLimit = (ByteSizeValue)this.clusterService.getClusterSettings().get(MachineLearningField.MAX_MODEL_MEMORY_LIMIT);
        if (maxModelMemoryLimit != null && maxModelMemoryLimit.getBytes() > 0L && maxModelMemoryLimit.getBytes() < defaultLimit.getBytes()) {
            return maxModelMemoryLimit;
        }
        return defaultLimit;
    }

    private Map<String, Object> datafeedsDefaults() {
        HashMap<String, Object> anomalyDetectorsDefaults = new HashMap<String, Object>();
        anomalyDetectorsDefaults.put(DatafeedConfig.SCROLL_SIZE.getPreferredName(), 1000);
        return anomalyDetectorsDefaults;
    }

    private Map<String, Object> limits() {
        HashMap<String, Object> limits = new HashMap<String, Object>();
        ByteSizeValue maxModelMemoryLimit = (ByteSizeValue)this.clusterService.getClusterSettings().get(MachineLearningField.MAX_MODEL_MEMORY_LIMIT);
        if (maxModelMemoryLimit != null && maxModelMemoryLimit.getBytes() > 0L) {
            limits.put("max_model_memory_limit", maxModelMemoryLimit);
        }
        return limits;
    }
}

