/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetDatafeedsStatsAction
extends TransportMasterNodeReadAction<GetDatafeedsStatsAction.Request, GetDatafeedsStatsAction.Response> {
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobResultsProvider jobResultsProvider;

    @Inject
    public TransportGetDatafeedsStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DatafeedConfigProvider datafeedConfigProvider, JobResultsProvider jobResultsProvider) {
        super("cluster:monitor/xpack/ml/datafeeds/stats/get", transportService, clusterService, threadPool, actionFilters, GetDatafeedsStatsAction.Request::new, indexNameExpressionResolver);
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.jobResultsProvider = jobResultsProvider;
    }

    protected String executor() {
        return "same";
    }

    protected GetDatafeedsStatsAction.Response read(StreamInput in) throws IOException {
        return new GetDatafeedsStatsAction.Response(in);
    }

    protected void masterOperation(GetDatafeedsStatsAction.Request request, ClusterState state, ActionListener<GetDatafeedsStatsAction.Response> listener) throws Exception {
        this.logger.debug("Get stats for datafeed '{}'", (Object)request.getDatafeedId());
        this.datafeedConfigProvider.expandDatafeedConfigs(request.getDatafeedId(), request.allowNoDatafeeds(), (ActionListener<List<DatafeedConfig.Builder>>)ActionListener.wrap(datafeedBuilders -> {
            List<String> jobIds = datafeedBuilders.stream().map(DatafeedConfig.Builder::build).map(DatafeedConfig::getJobId).collect(Collectors.toList());
            this.jobResultsProvider.datafeedTimingStats(jobIds, timingStatsByJobId -> {
                PersistentTasksCustomMetaData tasksInProgress = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
                List results = datafeedBuilders.stream().map(DatafeedConfig.Builder::build).map(datafeed -> TransportGetDatafeedsStatsAction.getDatafeedStats(datafeed.getId(), state, tasksInProgress, datafeed.getJobId(), (DatafeedTimingStats)timingStatsByJobId.get(datafeed.getJobId()))).collect(Collectors.toList());
                QueryPage statsPage = new QueryPage(results, (long)results.size(), DatafeedConfig.RESULTS_FIELD);
                listener.onResponse((Object)new GetDatafeedsStatsAction.Response(statsPage));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static GetDatafeedsStatsAction.Response.DatafeedStats getDatafeedStats(String datafeedId, ClusterState state, PersistentTasksCustomMetaData tasks, String jobId, DatafeedTimingStats timingStats) {
        PersistentTasksCustomMetaData.PersistentTask task = MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetaData)tasks);
        DatafeedState datafeedState = MlTasks.getDatafeedState((String)datafeedId, (PersistentTasksCustomMetaData)tasks);
        DiscoveryNode node = null;
        String explanation = null;
        if (task != null) {
            node = state.nodes().get(task.getExecutorNode());
            explanation = task.getAssignment().getExplanation();
        }
        if (timingStats == null) {
            timingStats = new DatafeedTimingStats(jobId);
        }
        return new GetDatafeedsStatsAction.Response.DatafeedStats(datafeedId, datafeedState, node, explanation, timingStats);
    }

    protected ClusterBlockException checkBlock(GetDatafeedsStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

