/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.saml;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionResponse;
import org.elasticsearch.xpack.security.rest.action.saml.SamlBaseRestHandler;

public class RestSamlInvalidateSessionAction
extends SamlBaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestSamlInvalidateSessionAction.class));
    static final ObjectParser<SamlInvalidateSessionRequest, RestSamlInvalidateSessionAction> PARSER = new ObjectParser("saml_invalidate_session", SamlInvalidateSessionRequest::new);

    public RestSamlInvalidateSessionAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_security/saml/invalidate", (RestHandler)this, RestRequest.Method.POST, "/_xpack/security/saml/invalidate", deprecationLogger);
    }

    public String getName() {
        return "security_saml_invalidate_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            SamlInvalidateSessionRequest invalidateRequest = (SamlInvalidateSessionRequest)PARSER.parse(parser, (Object)this);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)SamlInvalidateSessionAction.INSTANCE, (ActionRequest)invalidateRequest, (ActionListener)new RestBuilderListener<SamlInvalidateSessionResponse>(channel){

                public RestResponse buildResponse(SamlInvalidateSessionResponse resp, XContentBuilder builder) throws Exception {
                    builder.startObject();
                    builder.field("realm", resp.getRealmName());
                    builder.field("invalidated", resp.getCount());
                    builder.field("redirect", resp.getRedirectUrl());
                    builder.endObject();
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareString(SamlInvalidateSessionRequest::setQueryString, new ParseField("queryString", new String[0]));
        PARSER.declareString(SamlInvalidateSessionRequest::setAssertionConsumerServiceURL, new ParseField("acs", new String[0]));
        PARSER.declareString(SamlInvalidateSessionRequest::setRealmName, new ParseField("realm", new String[0]));
    }
}

