/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.DelegatePkiAuthenticationAction;
import org.elasticsearch.xpack.core.security.action.DelegatePkiAuthenticationRequest;
import org.elasticsearch.xpack.core.security.action.DelegatePkiAuthenticationResponse;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public final class RestDelegatePkiAuthenticationAction
extends SecurityBaseRestHandler {
    protected Logger logger = LogManager.getLogger(RestDelegatePkiAuthenticationAction.class);

    public RestDelegatePkiAuthenticationAction(Settings settings, RestController controller, XPackLicenseState xPackLicenseState) {
        super(settings, xPackLicenseState);
        controller.registerHandler(RestRequest.Method.POST, "/_security/delegate_pki", (RestHandler)this);
    }

    @Override
    protected Exception checkFeatureAvailable(RestRequest request) {
        Exception failedFeature = super.checkFeatureAvailable(request);
        if (failedFeature != null) {
            return failedFeature;
        }
        if (Realms.isRealmTypeAvailable(this.licenseState.allowedRealmType(), "pki")) {
            return null;
        }
        this.logger.info("The '{}' realm is not available under the current license", (Object)"pki");
        return LicenseUtils.newComplianceException((String)"pki");
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            DelegatePkiAuthenticationRequest delegatePkiRequest = DelegatePkiAuthenticationRequest.fromXContent((XContentParser)parser);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)DelegatePkiAuthenticationAction.INSTANCE, (ActionRequest)delegatePkiRequest, (ActionListener)new RestBuilderListener<DelegatePkiAuthenticationResponse>(channel){

                public RestResponse buildResponse(DelegatePkiAuthenticationResponse delegatePkiResponse, XContentBuilder builder) throws Exception {
                    delegatePkiResponse.toXContent(builder, (ToXContent.Params)this.channel.request());
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    public String getName() {
        return "delegate_pki_action";
    }
}

