/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class IndexTemplateConfig {
    private final String templateName;
    private final String fileName;
    private final String version;
    private final String versionProperty;

    public IndexTemplateConfig(String templateName, String fileName, String version, String versionProperty) {
        this.templateName = templateName;
        this.fileName = fileName;
        this.version = version;
        this.versionProperty = versionProperty;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public byte[] loadBytes() {
        String template = TemplateUtils.loadTemplate(this.fileName, this.version, Pattern.quote("${" + this.versionProperty + "}"));
        assert (template != null && template.length() > 0);
        return template.getBytes(StandardCharsets.UTF_8);
    }
}

