/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.user;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.user.XPackSecurityUser;
import org.elasticsearch.xpack.core.security.user.XPackUser;

public class InternalUserSerializationHelper {
    public static User readFrom(StreamInput input) throws IOException {
        boolean isInternalUser = input.readBoolean();
        String username = input.readString();
        if (isInternalUser) {
            if (SystemUser.is(username)) {
                return SystemUser.INSTANCE;
            }
            if (XPackUser.is(username)) {
                return XPackUser.INSTANCE;
            }
            if (XPackSecurityUser.is(username)) {
                return XPackSecurityUser.INSTANCE;
            }
            throw new IllegalStateException("user [" + username + "] is not an internal user");
        }
        return User.partialReadFrom(username, input);
    }

    public static void writeTo(User user, StreamOutput output) throws IOException {
        if (SystemUser.is(user)) {
            output.writeBoolean(true);
            output.writeString("_system");
        } else if (XPackUser.is(user)) {
            output.writeBoolean(true);
            output.writeString("_xpack");
        } else if (XPackSecurityUser.is(user)) {
            output.writeBoolean(true);
            output.writeString("_xpack_security");
        } else {
            User.writeTo(user, output);
        }
    }
}

