/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import org.elasticsearch.common.Strings;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.GetApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.NamedClusterPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public class ManageOwnApiKeyClusterPrivilege
implements NamedClusterPrivilege {
    public static final ManageOwnApiKeyClusterPrivilege INSTANCE = new ManageOwnApiKeyClusterPrivilege();
    private static final String PRIVILEGE_NAME = "manage_own_api_key";
    private static final String API_KEY_REALM_TYPE = "_es_api_key";
    private static final String API_KEY_ID_KEY = "_security_api_key_id";

    private ManageOwnApiKeyClusterPrivilege() {
    }

    @Override
    public String name() {
        return PRIVILEGE_NAME;
    }

    @Override
    public ClusterPermission.Builder buildPermission(ClusterPermission.Builder builder) {
        return builder.add(this, ManageOwnClusterPermissionCheck.INSTANCE);
    }

    private static final class ManageOwnClusterPermissionCheck
    extends ClusterPermission.ActionBasedPermissionCheck {
        public static final ManageOwnClusterPermissionCheck INSTANCE = new ManageOwnClusterPermissionCheck();

        private ManageOwnClusterPermissionCheck() {
            super(Automatons.patterns("cluster:admin/xpack/security/api_key/*"));
        }

        @Override
        protected boolean extendedCheck(String action, TransportRequest request, Authentication authentication) {
            if (request instanceof CreateApiKeyRequest) {
                return true;
            }
            if (request instanceof GetApiKeyRequest) {
                GetApiKeyRequest getApiKeyRequest = (GetApiKeyRequest)request;
                return this.checkIfUserIsOwnerOfApiKeys(authentication, getApiKeyRequest.getApiKeyId(), getApiKeyRequest.getUserName(), getApiKeyRequest.getRealmName(), getApiKeyRequest.ownedByAuthenticatedUser());
            }
            if (request instanceof InvalidateApiKeyRequest) {
                InvalidateApiKeyRequest invalidateApiKeyRequest = (InvalidateApiKeyRequest)request;
                return this.checkIfUserIsOwnerOfApiKeys(authentication, invalidateApiKeyRequest.getId(), invalidateApiKeyRequest.getUserName(), invalidateApiKeyRequest.getRealmName(), invalidateApiKeyRequest.ownedByAuthenticatedUser());
            }
            throw new IllegalArgumentException("manage own api key privilege only supports API key requests (not " + request.getClass().getName() + ")");
        }

        @Override
        protected boolean doImplies(ClusterPermission.ActionBasedPermissionCheck permissionCheck) {
            return permissionCheck instanceof ManageOwnClusterPermissionCheck;
        }

        private boolean checkIfUserIsOwnerOfApiKeys(Authentication authentication, String apiKeyId, String username, String realmName, boolean ownedByAuthenticatedUser) {
            if (this.isCurrentAuthenticationUsingSameApiKeyIdFromRequest(authentication, apiKeyId)) {
                return true;
            }
            if (authentication.getAuthenticatedBy().getType().equals(ManageOwnApiKeyClusterPrivilege.API_KEY_REALM_TYPE)) {
                return false;
            }
            if (ownedByAuthenticatedUser) {
                return true;
            }
            if (Strings.hasText((String)username) && Strings.hasText((String)realmName)) {
                String authenticatedUserPrincipal = authentication.getUser().principal();
                String authenticatedUserRealm = authentication.getAuthenticatedBy().getName();
                return username.equals(authenticatedUserPrincipal) && realmName.equals(authenticatedUserRealm);
            }
            return false;
        }

        private boolean isCurrentAuthenticationUsingSameApiKeyIdFromRequest(Authentication authentication, String apiKeyId) {
            if (authentication.getAuthenticatedBy().getType().equals(ManageOwnApiKeyClusterPrivilege.API_KEY_REALM_TYPE)) {
                String authenticatedApiKeyId = (String)authentication.getMetadata().get(ManageOwnApiKeyClusterPrivilege.API_KEY_ID_KEY);
                if (Strings.hasText((String)apiKeyId)) {
                    return apiKeyId.equals(authenticatedApiKeyId);
                }
            }
            return false;
        }
    }
}

