/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionModel;
import org.elasticsearch.xpack.core.security.support.MustacheTemplateEvaluator;

public class TemplateRoleName
implements ToXContentObject,
Writeable {
    private static final ConstructingObjectParser<TemplateRoleName, Void> PARSER = new ConstructingObjectParser("role-mapping-template", false, arr -> new TemplateRoleName((BytesReference)arr[0], (Format)((Object)((Object)arr[1]))));
    private final BytesReference template;
    private final Format format;

    public TemplateRoleName(BytesReference template, Format format) {
        this.template = template;
        this.format = format == null ? Format.STRING : format;
    }

    public TemplateRoleName(StreamInput in) throws IOException {
        this.template = in.readBytesReference();
        this.format = (Format)in.readEnum(Format.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBytesReference(this.template);
        out.writeEnum((Enum)this.format);
    }

    public BytesReference getTemplate() {
        return this.template;
    }

    public Format getFormat() {
        return this.format;
    }

    public List<String> getRoleNames(ScriptService scriptService, ExpressionModel model) {
        try {
            String evaluation = this.parseTemplate(scriptService, model.asMap());
            switch (this.format) {
                case STRING: {
                    return Collections.singletonList(evaluation);
                }
                case JSON: {
                    return this.convertJsonToList(evaluation);
                }
            }
            throw new IllegalStateException("Unsupported format [" + (Object)((Object)this.format) + "]");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<String> convertJsonToList(String evaluation) throws IOException {
        XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, evaluation);
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return Collections.singletonList(parser.text());
        }
        if (token == XContentParser.Token.START_ARRAY) {
            return parser.list().stream().filter(Objects::nonNull).map(o -> {
                if (o instanceof String) {
                    return (String)o;
                }
                throw new XContentParseException("Roles array may only contain strings but found [" + o.getClass().getName() + "] [" + o + "]");
            }).collect(Collectors.toList());
        }
        throw new XContentParseException("Roles template must generate a string or an array of strings, but found [" + token + "]");
    }

    private String parseTemplate(ScriptService scriptService, Map<String, Object> parameters) throws IOException {
        XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)this.template, (XContentType)XContentType.JSON);
        return MustacheTemplateEvaluator.evaluate(scriptService, parser, parameters);
    }

    private static BytesReference extractTemplate(XContentParser parser, Void ignore) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return new BytesArray(parser.text());
        }
        XContentBuilder builder = JsonXContent.contentBuilder();
        builder.generator().copyCurrentStructure(parser);
        return BytesReference.bytes((XContentBuilder)builder);
    }

    static TemplateRoleName parse(XContentParser parser) throws IOException {
        return (TemplateRoleName)PARSER.parse(parser, null);
    }

    public String toString() {
        return "template-" + (Object)((Object)this.format) + "{" + this.template.utf8ToString() + "}";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(Fields.TEMPLATE.getPreferredName(), this.template.utf8ToString()).field(Fields.FORMAT.getPreferredName(), this.format.formatName()).endObject();
    }

    public boolean isFragment() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateRoleName that = (TemplateRoleName)o;
        return Objects.equals(this.template, that.template) && this.format == that.format;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.template, this.format});
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), TemplateRoleName::extractTemplate, Fields.TEMPLATE, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), x$0 -> Format.fromXContent(x$0), Fields.FORMAT, ObjectParser.ValueType.STRING);
    }

    public static enum Format {
        JSON,
        STRING;


        private static Format fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token != XContentParser.Token.VALUE_STRING) {
                throw new XContentParseException(parser.getTokenLocation(), "Expected [" + XContentParser.Token.VALUE_STRING + "] but found [" + token + "]");
            }
            String text = parser.text();
            try {
                return Format.valueOf(text.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                String valueNames = Stream.of(Format.values()).map(Format::formatName).collect(Collectors.joining(","));
                throw new XContentParseException(parser.getTokenLocation(), "Invalid format [" + text + "] expected one of [" + valueNames + "]");
            }
        }

        public String formatName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    private static interface Fields {
        public static final ParseField TEMPLATE = new ParseField("template", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
    }
}

