/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.rollup.job.DateHistogramGroupConfig;
import org.elasticsearch.xpack.core.rollup.job.HistogramGroupConfig;
import org.elasticsearch.xpack.core.rollup.job.TermsGroupConfig;

public class GroupConfig
implements Writeable,
ToXContentObject {
    public static final String NAME = "groups";
    private static final ConstructingObjectParser<GroupConfig, Void> PARSER = new ConstructingObjectParser("groups", args -> new GroupConfig((DateHistogramGroupConfig)args[0], (HistogramGroupConfig)args[1], (TermsGroupConfig)args[2]));
    private final DateHistogramGroupConfig dateHistogram;
    @Nullable
    private final HistogramGroupConfig histogram;
    @Nullable
    private final TermsGroupConfig terms;

    public GroupConfig(DateHistogramGroupConfig dateHistogram) {
        this(dateHistogram, null, null);
    }

    public GroupConfig(DateHistogramGroupConfig dateHistogram, @Nullable HistogramGroupConfig histogram, @Nullable TermsGroupConfig terms) {
        if (dateHistogram == null) {
            throw new IllegalArgumentException("Date histogram must not be null");
        }
        this.dateHistogram = dateHistogram;
        this.histogram = histogram;
        this.terms = terms;
    }

    public GroupConfig(StreamInput in) throws IOException {
        this.dateHistogram = DateHistogramGroupConfig.fromUnknownTimeUnit(in);
        this.histogram = (HistogramGroupConfig)in.readOptionalWriteable(HistogramGroupConfig::new);
        this.terms = (TermsGroupConfig)in.readOptionalWriteable(TermsGroupConfig::new);
    }

    public DateHistogramGroupConfig getDateHistogram() {
        return this.dateHistogram;
    }

    @Nullable
    public HistogramGroupConfig getHistogram() {
        return this.histogram;
    }

    @Nullable
    public TermsGroupConfig getTerms() {
        return this.terms;
    }

    public Set<String> getAllFields() {
        HashSet<String> fields = new HashSet<String>();
        fields.add(this.dateHistogram.getField());
        if (this.histogram != null) {
            fields.addAll(Arrays.asList(this.histogram.getFields()));
        }
        if (this.terms != null) {
            fields.addAll(Arrays.asList(this.terms.getFields()));
        }
        return Collections.unmodifiableSet(fields);
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        this.dateHistogram.validateMappings(fieldCapsResponse, validationException);
        if (this.histogram != null) {
            this.histogram.validateMappings(fieldCapsResponse, validationException);
        }
        if (this.terms != null) {
            this.terms.validateMappings(fieldCapsResponse, validationException);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("date_histogram", (ToXContent)this.dateHistogram);
        if (this.histogram != null) {
            builder.field("histogram", (ToXContent)this.histogram);
        }
        if (this.terms != null) {
            builder.field("terms", (ToXContent)this.terms);
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.dateHistogram.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.histogram);
        out.writeOptionalWriteable((Writeable)this.terms);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GroupConfig that = (GroupConfig)other;
        return Objects.equals(this.dateHistogram, that.dateHistogram) && Objects.equals(this.histogram, that.histogram) && Objects.equals(this.terms, that.terms);
    }

    public int hashCode() {
        return Objects.hash(this.dateHistogram, this.histogram, this.terms);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static GroupConfig fromXContent(XContentParser parser) throws IOException {
        return (GroupConfig)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DateHistogramGroupConfig.fromXContent(p), new ParseField("date_histogram", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> HistogramGroupConfig.fromXContent(p), new ParseField("histogram", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TermsGroupConfig.fromXContent(p), new ParseField("terms", new String[0]));
    }
}

