/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.state;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExponentialAverageCalculationContext;

public class TimingStats
implements ToXContentObject,
Writeable {
    public static final ParseField BUCKET_COUNT = new ParseField("bucket_count", new String[0]);
    public static final ParseField TOTAL_BUCKET_PROCESSING_TIME_MS = new ParseField("total_bucket_processing_time_ms", new String[0]);
    public static final ParseField MIN_BUCKET_PROCESSING_TIME_MS = new ParseField("minimum_bucket_processing_time_ms", new String[0]);
    public static final ParseField MAX_BUCKET_PROCESSING_TIME_MS = new ParseField("maximum_bucket_processing_time_ms", new String[0]);
    public static final ParseField AVG_BUCKET_PROCESSING_TIME_MS = new ParseField("average_bucket_processing_time_ms", new String[0]);
    public static final ParseField EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_MS = new ParseField("exponential_average_bucket_processing_time_ms", new String[0]);
    public static final ParseField EXPONENTIAL_AVG_CALCULATION_CONTEXT = new ParseField("exponential_average_calculation_context", new String[0]);
    public static final ParseField EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_PER_HOUR_MS = new ParseField("exponential_average_bucket_processing_time_per_hour_ms", new String[0]);
    public static final ParseField TYPE = new ParseField("timing_stats", new String[0]);
    public static final ConstructingObjectParser<TimingStats, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), true, args -> {
        String jobId = (String)args[0];
        long bucketCount = (Long)args[1];
        Double minBucketProcessingTimeMs = (Double)args[2];
        Double maxBucketProcessingTimeMs = (Double)args[3];
        Double avgBucketProcessingTimeMs = (Double)args[4];
        Double exponentialAvgBucketProcessingTimeMs = (Double)args[5];
        ExponentialAverageCalculationContext exponentialAvgCalculationContext = (ExponentialAverageCalculationContext)args[6];
        return new TimingStats(jobId, bucketCount, minBucketProcessingTimeMs, maxBucketProcessingTimeMs, avgBucketProcessingTimeMs, exponentialAvgBucketProcessingTimeMs, TimingStats.getOrDefault(exponentialAvgCalculationContext, new ExponentialAverageCalculationContext()));
    });
    private final String jobId;
    private long bucketCount;
    private Double minBucketProcessingTimeMs;
    private Double maxBucketProcessingTimeMs;
    private Double avgBucketProcessingTimeMs;
    private Double exponentialAvgBucketProcessingTimeMs;
    private final ExponentialAverageCalculationContext exponentialAvgCalculationContext;
    private static double ALPHA;

    public static String documentId(String jobId) {
        return jobId + "_timing_stats";
    }

    public TimingStats(String jobId, long bucketCount, @Nullable Double minBucketProcessingTimeMs, @Nullable Double maxBucketProcessingTimeMs, @Nullable Double avgBucketProcessingTimeMs, @Nullable Double exponentialAvgBucketProcessingTimeMs, ExponentialAverageCalculationContext exponentialAvgCalculationContext) {
        this.jobId = Objects.requireNonNull(jobId);
        this.bucketCount = bucketCount;
        this.minBucketProcessingTimeMs = minBucketProcessingTimeMs;
        this.maxBucketProcessingTimeMs = maxBucketProcessingTimeMs;
        this.avgBucketProcessingTimeMs = avgBucketProcessingTimeMs;
        this.exponentialAvgBucketProcessingTimeMs = exponentialAvgBucketProcessingTimeMs;
        this.exponentialAvgCalculationContext = Objects.requireNonNull(exponentialAvgCalculationContext);
    }

    public TimingStats(String jobId) {
        this(jobId, 0L, null, null, null, null, new ExponentialAverageCalculationContext());
    }

    public TimingStats(TimingStats lhs) {
        this(lhs.jobId, lhs.bucketCount, lhs.minBucketProcessingTimeMs, lhs.maxBucketProcessingTimeMs, lhs.avgBucketProcessingTimeMs, lhs.exponentialAvgBucketProcessingTimeMs, new ExponentialAverageCalculationContext(lhs.exponentialAvgCalculationContext));
    }

    public TimingStats(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.bucketCount = in.readLong();
        this.minBucketProcessingTimeMs = in.readOptionalDouble();
        this.maxBucketProcessingTimeMs = in.readOptionalDouble();
        this.avgBucketProcessingTimeMs = in.readOptionalDouble();
        this.exponentialAvgBucketProcessingTimeMs = in.readOptionalDouble();
        this.exponentialAvgCalculationContext = in.getVersion().onOrAfter(Version.V_7_4_0) ? (ExponentialAverageCalculationContext)in.readOptionalWriteable(ExponentialAverageCalculationContext::new) : new ExponentialAverageCalculationContext();
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getBucketCount() {
        return this.bucketCount;
    }

    public double getTotalBucketProcessingTimeMs() {
        return this.avgBucketProcessingTimeMs != null ? (double)this.bucketCount * this.avgBucketProcessingTimeMs : 0.0;
    }

    public Double getMinBucketProcessingTimeMs() {
        return this.minBucketProcessingTimeMs;
    }

    public Double getMaxBucketProcessingTimeMs() {
        return this.maxBucketProcessingTimeMs;
    }

    public Double getAvgBucketProcessingTimeMs() {
        return this.avgBucketProcessingTimeMs;
    }

    public Double getExponentialAvgBucketProcessingTimeMs() {
        return this.exponentialAvgBucketProcessingTimeMs;
    }

    public Double getExponentialAvgBucketProcessingTimePerHourMs() {
        return this.exponentialAvgCalculationContext.getCurrentExponentialAverageMs();
    }

    ExponentialAverageCalculationContext getExponentialAvgCalculationContext() {
        return this.exponentialAvgCalculationContext;
    }

    public void updateStats(double bucketProcessingTimeMs) {
        if (bucketProcessingTimeMs < 0.0) {
            throw new IllegalArgumentException("bucketProcessingTimeMs must be non-negative, was: " + bucketProcessingTimeMs);
        }
        if (this.minBucketProcessingTimeMs == null || bucketProcessingTimeMs < this.minBucketProcessingTimeMs) {
            this.minBucketProcessingTimeMs = bucketProcessingTimeMs;
        }
        if (this.maxBucketProcessingTimeMs == null || bucketProcessingTimeMs > this.maxBucketProcessingTimeMs) {
            this.maxBucketProcessingTimeMs = bucketProcessingTimeMs;
        }
        this.avgBucketProcessingTimeMs = this.avgBucketProcessingTimeMs == null ? Double.valueOf(bucketProcessingTimeMs) : Double.valueOf(((double)this.bucketCount * this.avgBucketProcessingTimeMs + bucketProcessingTimeMs) / (double)(this.bucketCount + 1L));
        this.exponentialAvgBucketProcessingTimeMs = this.exponentialAvgBucketProcessingTimeMs == null ? Double.valueOf(bucketProcessingTimeMs) : Double.valueOf((1.0 - ALPHA) * this.exponentialAvgBucketProcessingTimeMs + ALPHA * bucketProcessingTimeMs);
        ++this.bucketCount;
        this.exponentialAvgCalculationContext.increment(bucketProcessingTimeMs);
    }

    public void setLatestRecordTimestamp(Instant latestRecordTimestamp) {
        this.exponentialAvgCalculationContext.setLatestTimestamp(latestRecordTimestamp);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeLong(this.bucketCount);
        out.writeOptionalDouble(this.minBucketProcessingTimeMs);
        out.writeOptionalDouble(this.maxBucketProcessingTimeMs);
        out.writeOptionalDouble(this.avgBucketProcessingTimeMs);
        out.writeOptionalDouble(this.exponentialAvgBucketProcessingTimeMs);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeOptionalWriteable((Writeable)this.exponentialAvgCalculationContext);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Double expAvgBucketProcessingTimePerHourMs;
        builder.startObject();
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(Result.RESULT_TYPE.getPreferredName(), TYPE.getPreferredName());
        }
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(BUCKET_COUNT.getPreferredName(), this.bucketCount);
        if (params.paramAsBoolean("include_calculated_fields", false)) {
            builder.field(TOTAL_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.getTotalBucketProcessingTimeMs());
        }
        if (this.minBucketProcessingTimeMs != null) {
            builder.field(MIN_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.minBucketProcessingTimeMs);
        }
        if (this.maxBucketProcessingTimeMs != null) {
            builder.field(MAX_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.maxBucketProcessingTimeMs);
        }
        if (this.avgBucketProcessingTimeMs != null) {
            builder.field(AVG_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.avgBucketProcessingTimeMs);
        }
        if (this.exponentialAvgBucketProcessingTimeMs != null) {
            builder.field(EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.exponentialAvgBucketProcessingTimeMs);
        }
        if (params.paramAsBoolean("include_calculated_fields", false) && (expAvgBucketProcessingTimePerHourMs = this.getExponentialAvgBucketProcessingTimePerHourMs()) != null) {
            builder.field(EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_PER_HOUR_MS.getPreferredName(), expAvgBucketProcessingTimePerHourMs);
        }
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(EXPONENTIAL_AVG_CALCULATION_CONTEXT.getPreferredName(), (ToXContent)this.exponentialAvgCalculationContext);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimingStats that = (TimingStats)o;
        return Objects.equals(this.jobId, that.jobId) && this.bucketCount == that.bucketCount && Objects.equals(this.minBucketProcessingTimeMs, that.minBucketProcessingTimeMs) && Objects.equals(this.maxBucketProcessingTimeMs, that.maxBucketProcessingTimeMs) && Objects.equals(this.avgBucketProcessingTimeMs, that.avgBucketProcessingTimeMs) && Objects.equals(this.exponentialAvgBucketProcessingTimeMs, that.exponentialAvgBucketProcessingTimeMs) && Objects.equals(this.exponentialAvgCalculationContext, that.exponentialAvgCalculationContext);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.bucketCount, this.minBucketProcessingTimeMs, this.maxBucketProcessingTimeMs, this.avgBucketProcessingTimeMs, this.exponentialAvgBucketProcessingTimeMs, this.exponentialAvgCalculationContext);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    private static <T> T getOrDefault(@Nullable T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_COUNT);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), MIN_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), MAX_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), AVG_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ExponentialAverageCalculationContext.PARSER, EXPONENTIAL_AVG_CALCULATION_CONTEXT);
        ALPHA = 0.01;
    }
}

