/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;

public class ScoreByThresholdResult
implements EvaluationMetricResult {
    public static final String NAME = "score_by_threshold_result";
    private final String name;
    private final double[] thresholds;
    private final double[] scores;

    public ScoreByThresholdResult(String name, double[] thresholds, double[] scores) {
        assert (thresholds.length == scores.length);
        this.name = Objects.requireNonNull(name);
        this.thresholds = thresholds;
        this.scores = scores;
    }

    public ScoreByThresholdResult(StreamInput in) throws IOException {
        this.name = in.readString();
        this.thresholds = in.readDoubleArray();
        this.scores = in.readDoubleArray();
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeDoubleArray(this.thresholds);
        out.writeDoubleArray(this.scores);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (int i = 0; i < this.thresholds.length; ++i) {
            builder.field(String.valueOf(this.thresholds[i]), this.scores[i]);
        }
        builder.endObject();
        return builder;
    }
}

