/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.index.mapper.NumberFieldMapper;

public final class Types {
    private static final Set<String> CATEGORICAL_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("text", "keyword", "ip")));
    private static final Set<String> NUMERICAL_TYPES;

    private Types() {
    }

    public static Set<String> categorical() {
        return CATEGORICAL_TYPES;
    }

    public static Set<String> numerical() {
        return NUMERICAL_TYPES;
    }

    static {
        Set numericalTypes = Stream.of(NumberFieldMapper.NumberType.values()).map(NumberFieldMapper.NumberType::typeName).collect(Collectors.toSet());
        numericalTypes.add("scaled_float");
        NUMERICAL_TYPES = Collections.unmodifiableSet(numericalTypes);
    }
}

