/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.JobTaskRequest;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;

public class ForecastJobAction
extends ActionType<Response> {
    public static final ForecastJobAction INSTANCE = new ForecastJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/forecast";

    private ForecastJobAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private boolean acknowledged;
        private String forecastId;

        public Response(boolean acknowledged, String forecastId) {
            super(null, null);
            this.acknowledged = acknowledged;
            this.forecastId = forecastId;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.acknowledged = in.readBoolean();
            this.forecastId = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.acknowledged);
            out.writeString(this.forecastId);
        }

        public boolean isAcknowledged() {
            return this.acknowledged;
        }

        public String getForecastId() {
            return this.forecastId;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("acknowledged", this.acknowledged);
            builder.field(Forecast.FORECAST_ID.getPreferredName(), this.forecastId);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return this.acknowledged == other.acknowledged && Objects.equals(this.forecastId, other.forecastId);
        }

        public int hashCode() {
            return Objects.hash(this.acknowledged, this.forecastId);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        RequestBuilder(ElasticsearchClient client, ForecastJobAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends JobTaskRequest<Request>
    implements ToXContentObject {
        public static final ParseField DURATION = new ParseField("duration", new String[0]);
        public static final ParseField EXPIRES_IN = new ParseField("expires_in", new String[0]);
        private static final TimeValue MAX_DURATION = TimeValue.parseTimeValue((String)"3650d", (String)"");
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/forecast", Request::new);
        private TimeValue duration;
        private TimeValue expiresIn;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.duration = in.readOptionalTimeValue();
            this.expiresIn = in.readOptionalTimeValue();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalTimeValue(this.duration);
            out.writeOptionalTimeValue(this.expiresIn);
        }

        public Request(String jobId) {
            super(jobId);
        }

        public TimeValue getDuration() {
            return this.duration;
        }

        public void setDuration(String duration) {
            this.setDuration(TimeValue.parseTimeValue((String)duration, (String)DURATION.getPreferredName()));
        }

        public void setDuration(TimeValue duration) {
            this.duration = duration;
            if (this.duration.compareTo(TimeValue.ZERO) <= 0) {
                throw new IllegalArgumentException("[" + DURATION.getPreferredName() + "] must be positive: [" + duration.getStringRep() + "]");
            }
            if (this.duration.compareTo(MAX_DURATION) > 0) {
                throw new IllegalArgumentException("[" + DURATION.getPreferredName() + "] must be " + MAX_DURATION.getStringRep() + " or less: [" + duration.getStringRep() + "]");
            }
        }

        public TimeValue getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(String expiration) {
            this.setExpiresIn(TimeValue.parseTimeValue((String)expiration, (String)EXPIRES_IN.getPreferredName()));
        }

        public void setExpiresIn(TimeValue expiresIn) {
            this.expiresIn = expiresIn;
            if (this.expiresIn.compareTo(TimeValue.ZERO) < 0) {
                throw new IllegalArgumentException("[" + EXPIRES_IN.getPreferredName() + "] must be non-negative: [" + expiresIn.getStringRep() + "]");
            }
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.duration, this.expiresIn);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.duration, other.duration) && Objects.equals(this.expiresIn, other.expiresIn);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            if (this.duration != null) {
                builder.field(DURATION.getPreferredName(), this.duration.getStringRep());
            }
            if (this.expiresIn != null) {
                builder.field(EXPIRES_IN.getPreferredName(), this.expiresIn.getStringRep());
            }
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareString(Request::setDuration, DURATION);
            PARSER.declareString(Request::setExpiresIn, EXPIRES_IN);
        }
    }
}

