/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;

class WaitForYellowStep
extends ClusterStateWaitStep {
    static final String NAME = "wait-for-yellow-step";

    WaitForYellowStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        RoutingTable routingTable = clusterState.routingTable();
        IndexRoutingTable indexShardRoutingTable = routingTable.index(index);
        if (indexShardRoutingTable == null) {
            return new ClusterStateWaitStep.Result(false, new Info("index is red; no IndexRoutingTable"));
        }
        boolean indexIsAtLeastYellow = indexShardRoutingTable.allPrimaryShardsActive();
        if (indexIsAtLeastYellow) {
            return new ClusterStateWaitStep.Result(true, null);
        }
        return new ClusterStateWaitStep.Result(false, new Info("index is red; not all primary shards are active"));
    }

    static final class Info
    implements ToXContentObject {
        static final ParseField MESSAGE_FIELD = new ParseField("message", new String[0]);
        private final String message;

        Info(String message) {
            this.message = message;
        }

        String getMessage() {
            return this.message;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE_FIELD.getPreferredName(), this.message);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            return Objects.equals(this.getMessage(), info.getMessage());
        }

        public int hashCode() {
            return Objects.hash(this.getMessage());
        }
    }
}

