/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Step;

public class ShrinkStep
extends AsyncActionStep {
    public static final String NAME = "shrink";
    private int numberOfShards;
    private String shrunkIndexPrefix;

    public ShrinkStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, int numberOfShards, String shrunkIndexPrefix) {
        super(key, nextStepKey, client);
        this.numberOfShards = numberOfShards;
        this.shrunkIndexPrefix = shrunkIndexPrefix;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    String getShrunkIndexPrefix() {
        return this.shrunkIndexPrefix;
    }

    @Override
    public void performAction(IndexMetaData indexMetaData, ClusterState currentState, ClusterStateObserver observer, AsyncActionStep.Listener listener) {
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetaData);
        if (lifecycleState.getLifecycleDate() == null) {
            throw new IllegalStateException("source index [" + indexMetaData.getIndex().getName() + "] is missing lifecycle date");
        }
        String lifecycle = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetaData.getSettings());
        Settings relevantTargetSettings = Settings.builder().put("index.number_of_shards", this.numberOfShards).put("index.number_of_replicas", indexMetaData.getNumberOfReplicas()).put("index.lifecycle.name", lifecycle).put(IndexMetaData.INDEX_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_id", (String)null).build();
        String shrunkenIndexName = this.shrunkIndexPrefix + indexMetaData.getIndex().getName();
        ResizeRequest resizeRequest = new ResizeRequest(shrunkenIndexName, indexMetaData.getIndex().getName());
        resizeRequest.getTargetIndexRequest().settings(relevantTargetSettings);
        this.getClient().admin().indices().resizeIndex(resizeRequest, ActionListener.wrap(response -> listener.onResponse(response.isAcknowledged()), listener::onFailure));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numberOfShards, this.shrunkIndexPrefix);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShrinkStep other = (ShrinkStep)obj;
        return super.equals(obj) && Objects.equals(this.numberOfShards, other.numberOfShards) && Objects.equals(this.shrunkIndexPrefix, other.shrunkIndexPrefix);
    }
}

