/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.BranchingStep;
import org.elasticsearch.xpack.core.ilm.CheckShrinkReadyStep;
import org.elasticsearch.xpack.core.ilm.CopyExecutionStateStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.SetSingleNodeAllocateStep;
import org.elasticsearch.xpack.core.ilm.ShrinkSetAliasStep;
import org.elasticsearch.xpack.core.ilm.ShrinkStep;
import org.elasticsearch.xpack.core.ilm.ShrunkShardsAllocatedStep;
import org.elasticsearch.xpack.core.ilm.ShrunkenIndexCheckStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UpdateSettingsStep;
import org.elasticsearch.xpack.core.ilm.WaitForNoFollowersStep;

public class ShrinkAction
implements LifecycleAction {
    public static final String NAME = "shrink";
    public static final String SHRUNKEN_INDEX_PREFIX = "shrink-";
    public static final ParseField NUMBER_OF_SHARDS_FIELD = new ParseField("number_of_shards", new String[0]);
    private static final ConstructingObjectParser<ShrinkAction, Void> PARSER = new ConstructingObjectParser("shrink", a -> new ShrinkAction((Integer)a[0]));
    private int numberOfShards;

    public static ShrinkAction parse(XContentParser parser) throws IOException {
        return (ShrinkAction)PARSER.parse(parser, null);
    }

    public ShrinkAction(int numberOfShards) {
        if (numberOfShards <= 0) {
            throw new IllegalArgumentException("[" + NUMBER_OF_SHARDS_FIELD.getPreferredName() + "] must be greater than 0");
        }
        this.numberOfShards = numberOfShards;
    }

    public ShrinkAction(StreamInput in) throws IOException {
        this.numberOfShards = in.readVInt();
    }

    int getNumberOfShards() {
        return this.numberOfShards;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numberOfShards);
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUMBER_OF_SHARDS_FIELD.getPreferredName(), this.numberOfShards);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isSafeAction() {
        return false;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Settings readOnlySettings = Settings.builder().put("index.blocks.write", true).build();
        Step.StepKey branchingKey = new Step.StepKey(phase, NAME, "branch");
        Step.StepKey waitForNoFollowerStepKey = new Step.StepKey(phase, NAME, "wait-for-shard-history-leases");
        Step.StepKey readOnlyKey = new Step.StepKey(phase, NAME, "readonly");
        Step.StepKey setSingleNodeKey = new Step.StepKey(phase, NAME, "set-single-node-allocation");
        Step.StepKey allocationRoutedKey = new Step.StepKey(phase, NAME, "check-shrink-allocation");
        Step.StepKey shrinkKey = new Step.StepKey(phase, NAME, NAME);
        Step.StepKey enoughShardsKey = new Step.StepKey(phase, NAME, "shrunk-shards-allocated");
        Step.StepKey copyMetadataKey = new Step.StepKey(phase, NAME, "copy-execution-state");
        Step.StepKey aliasKey = new Step.StepKey(phase, NAME, "aliases");
        Step.StepKey isShrunkIndexKey = new Step.StepKey(phase, NAME, "is-shrunken-index");
        BranchingStep conditionalSkipShrinkStep = new BranchingStep(branchingKey, waitForNoFollowerStepKey, nextStepKey, (index, clusterState) -> clusterState.getMetaData().index(index).getNumberOfShards() == this.numberOfShards);
        WaitForNoFollowersStep waitForNoFollowersStep = new WaitForNoFollowersStep(waitForNoFollowerStepKey, readOnlyKey, client);
        UpdateSettingsStep readOnlyStep = new UpdateSettingsStep(readOnlyKey, setSingleNodeKey, client, readOnlySettings);
        SetSingleNodeAllocateStep setSingleNodeStep = new SetSingleNodeAllocateStep(setSingleNodeKey, allocationRoutedKey, client);
        CheckShrinkReadyStep checkShrinkReadyStep = new CheckShrinkReadyStep(allocationRoutedKey, shrinkKey);
        ShrinkStep shrink = new ShrinkStep(shrinkKey, enoughShardsKey, client, this.numberOfShards, SHRUNKEN_INDEX_PREFIX);
        ShrunkShardsAllocatedStep allocated = new ShrunkShardsAllocatedStep(enoughShardsKey, copyMetadataKey, SHRUNKEN_INDEX_PREFIX);
        CopyExecutionStateStep copyMetadata = new CopyExecutionStateStep(copyMetadataKey, aliasKey, SHRUNKEN_INDEX_PREFIX);
        ShrinkSetAliasStep aliasSwapAndDelete = new ShrinkSetAliasStep(aliasKey, isShrunkIndexKey, client, SHRUNKEN_INDEX_PREFIX);
        ShrunkenIndexCheckStep waitOnShrinkTakeover = new ShrunkenIndexCheckStep(isShrunkIndexKey, nextStepKey, SHRUNKEN_INDEX_PREFIX);
        return Arrays.asList(conditionalSkipShrinkStep, waitForNoFollowersStep, readOnlyStep, setSingleNodeStep, checkShrinkReadyStep, shrink, allocated, copyMetadata, aliasSwapAndDelete, waitOnShrinkTakeover);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShrinkAction that = (ShrinkAction)o;
        return Objects.equals(this.numberOfShards, that.numberOfShards);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfShards);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), NUMBER_OF_SHARDS_FIELD);
    }
}

