/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.metadata.IndexMetaData;

public class LifecycleExecutionState {
    public static final String ILM_CUSTOM_METADATA_KEY = "ilm";
    private static final String PHASE = "phase";
    private static final String ACTION = "action";
    private static final String STEP = "step";
    private static final String INDEX_CREATION_DATE = "creation_date";
    private static final String PHASE_TIME = "phase_time";
    private static final String ACTION_TIME = "action_time";
    private static final String STEP_TIME = "step_time";
    private static final String FAILED_STEP = "failed_step";
    private static final String STEP_INFO = "step_info";
    private static final String PHASE_DEFINITION = "phase_definition";
    private final String phase;
    private final String action;
    private final String step;
    private final String failedStep;
    private final String stepInfo;
    private final String phaseDefinition;
    private final Long lifecycleDate;
    private final Long phaseTime;
    private final Long actionTime;
    private final Long stepTime;

    private LifecycleExecutionState(String phase, String action, String step, String failedStep, String stepInfo, String phaseDefinition, Long lifecycleDate, Long phaseTime, Long actionTime, Long stepTime) {
        this.phase = phase;
        this.action = action;
        this.step = step;
        this.failedStep = failedStep;
        this.stepInfo = stepInfo;
        this.phaseDefinition = phaseDefinition;
        this.lifecycleDate = lifecycleDate;
        this.phaseTime = phaseTime;
        this.actionTime = actionTime;
        this.stepTime = stepTime;
    }

    public static LifecycleExecutionState fromIndexMetadata(IndexMetaData indexMetaData) {
        Map customData = indexMetaData.getCustomData(ILM_CUSTOM_METADATA_KEY);
        customData = customData == null ? new HashMap() : customData;
        return LifecycleExecutionState.fromCustomMetadata(customData);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LifecycleExecutionState state) {
        return new Builder().setPhase(state.phase).setAction(state.action).setStep(state.step).setFailedStep(state.failedStep).setStepInfo(state.stepInfo).setPhaseDefinition(state.phaseDefinition).setIndexCreationDate(state.lifecycleDate).setPhaseTime(state.phaseTime).setActionTime(state.actionTime).setStepTime(state.stepTime);
    }

    static LifecycleExecutionState fromCustomMetadata(Map<String, String> customData) {
        Builder builder = LifecycleExecutionState.builder();
        if (customData.containsKey(PHASE)) {
            builder.setPhase(customData.get(PHASE));
        }
        if (customData.containsKey(ACTION)) {
            builder.setAction(customData.get(ACTION));
        }
        if (customData.containsKey(STEP)) {
            builder.setStep(customData.get(STEP));
        }
        if (customData.containsKey(FAILED_STEP)) {
            builder.setFailedStep(customData.get(FAILED_STEP));
        }
        if (customData.containsKey(STEP_INFO)) {
            builder.setStepInfo(customData.get(STEP_INFO));
        }
        if (customData.containsKey(PHASE_DEFINITION)) {
            builder.setPhaseDefinition(customData.get(PHASE_DEFINITION));
        }
        if (customData.containsKey(INDEX_CREATION_DATE)) {
            try {
                builder.setIndexCreationDate(Long.parseLong(customData.get(INDEX_CREATION_DATE)));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, new Object[]{INDEX_CREATION_DATE, customData.get(INDEX_CREATION_DATE)});
            }
        }
        if (customData.containsKey(PHASE_TIME)) {
            try {
                builder.setPhaseTime(Long.parseLong(customData.get(PHASE_TIME)));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, new Object[]{PHASE_TIME, customData.get(PHASE_TIME)});
            }
        }
        if (customData.containsKey(ACTION_TIME)) {
            try {
                builder.setActionTime(Long.parseLong(customData.get(ACTION_TIME)));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, new Object[]{ACTION_TIME, customData.get(ACTION_TIME)});
            }
        }
        if (customData.containsKey(STEP_TIME)) {
            try {
                builder.setStepTime(Long.parseLong(customData.get(STEP_TIME)));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, new Object[]{STEP_TIME, customData.get(STEP_TIME)});
            }
        }
        return builder.build();
    }

    public Map<String, String> asMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.phase != null) {
            result.put(PHASE, this.phase);
        }
        if (this.action != null) {
            result.put(ACTION, this.action);
        }
        if (this.step != null) {
            result.put(STEP, this.step);
        }
        if (this.failedStep != null) {
            result.put(FAILED_STEP, this.failedStep);
        }
        if (this.stepInfo != null) {
            result.put(STEP_INFO, this.stepInfo);
        }
        if (this.lifecycleDate != null) {
            result.put(INDEX_CREATION_DATE, String.valueOf(this.lifecycleDate));
        }
        if (this.phaseTime != null) {
            result.put(PHASE_TIME, String.valueOf(this.phaseTime));
        }
        if (this.actionTime != null) {
            result.put(ACTION_TIME, String.valueOf(this.actionTime));
        }
        if (this.stepTime != null) {
            result.put(STEP_TIME, String.valueOf(this.stepTime));
        }
        if (this.phaseDefinition != null) {
            result.put(PHASE_DEFINITION, String.valueOf(this.phaseDefinition));
        }
        return Collections.unmodifiableMap(result);
    }

    public String getPhase() {
        return this.phase;
    }

    public String getAction() {
        return this.action;
    }

    public String getStep() {
        return this.step;
    }

    public String getFailedStep() {
        return this.failedStep;
    }

    public String getStepInfo() {
        return this.stepInfo;
    }

    public String getPhaseDefinition() {
        return this.phaseDefinition;
    }

    public Long getLifecycleDate() {
        return this.lifecycleDate;
    }

    public Long getPhaseTime() {
        return this.phaseTime;
    }

    public Long getActionTime() {
        return this.actionTime;
    }

    public Long getStepTime() {
        return this.stepTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LifecycleExecutionState that = (LifecycleExecutionState)o;
        return Objects.equals(this.getLifecycleDate(), that.getLifecycleDate()) && Objects.equals(this.getPhaseTime(), that.getPhaseTime()) && Objects.equals(this.getActionTime(), that.getActionTime()) && Objects.equals(this.getStepTime(), that.getStepTime()) && Objects.equals(this.getPhase(), that.getPhase()) && Objects.equals(this.getAction(), that.getAction()) && Objects.equals(this.getStep(), that.getStep()) && Objects.equals(this.getFailedStep(), that.getFailedStep()) && Objects.equals(this.getStepInfo(), that.getStepInfo()) && Objects.equals(this.getPhaseDefinition(), that.getPhaseDefinition());
    }

    public int hashCode() {
        return Objects.hash(this.getPhase(), this.getAction(), this.getStep(), this.getFailedStep(), this.getStepInfo(), this.getPhaseDefinition(), this.getLifecycleDate(), this.getPhaseTime(), this.getActionTime(), this.getStepTime());
    }

    public static class Builder {
        private String phase;
        private String action;
        private String step;
        private String failedStep;
        private String stepInfo;
        private String phaseDefinition;
        private Long indexCreationDate;
        private Long phaseTime;
        private Long actionTime;
        private Long stepTime;

        public Builder setPhase(String phase) {
            this.phase = phase;
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder setStep(String step) {
            this.step = step;
            return this;
        }

        public Builder setFailedStep(String failedStep) {
            this.failedStep = failedStep;
            return this;
        }

        public Builder setStepInfo(String stepInfo) {
            this.stepInfo = stepInfo;
            return this;
        }

        public Builder setPhaseDefinition(String phaseDefinition) {
            this.phaseDefinition = phaseDefinition;
            return this;
        }

        public Builder setIndexCreationDate(Long indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
            return this;
        }

        public Builder setPhaseTime(Long phaseTime) {
            this.phaseTime = phaseTime;
            return this;
        }

        public Builder setActionTime(Long actionTime) {
            this.actionTime = actionTime;
            return this;
        }

        public Builder setStepTime(Long stepTime) {
            this.stepTime = stepTime;
            return this;
        }

        public LifecycleExecutionState build() {
            return new LifecycleExecutionState(this.phase, this.action, this.step, this.failedStep, this.stepInfo, this.phaseDefinition, this.indexCreationDate, this.phaseTime, this.actionTime, this.stepTime);
        }
    }
}

