/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;

public class IndexLifecycleMetadata
implements XPackPlugin.XPackMetaDataCustom {
    public static final String TYPE = "index_lifecycle";
    public static final ParseField OPERATION_MODE_FIELD = new ParseField("operation_mode", new String[0]);
    public static final ParseField POLICIES_FIELD = new ParseField("policies", new String[0]);
    public static final IndexLifecycleMetadata EMPTY = new IndexLifecycleMetadata(Collections.emptySortedMap(), OperationMode.RUNNING);
    public static final ConstructingObjectParser<IndexLifecycleMetadata, Void> PARSER = new ConstructingObjectParser("index_lifecycle", a -> new IndexLifecycleMetadata(((List)a[0]).stream().collect(Collectors.toMap(LifecyclePolicyMetadata::getName, Function.identity())), OperationMode.valueOf((String)a[1])));
    private final Map<String, LifecyclePolicyMetadata> policyMetadatas;
    private final OperationMode operationMode;

    public IndexLifecycleMetadata(Map<String, LifecyclePolicyMetadata> policies, OperationMode operationMode) {
        this.policyMetadatas = Collections.unmodifiableMap(policies);
        this.operationMode = operationMode;
    }

    public IndexLifecycleMetadata(StreamInput in) throws IOException {
        int size = in.readVInt();
        TreeMap<String, LifecyclePolicyMetadata> policies = new TreeMap<String, LifecyclePolicyMetadata>();
        for (int i = 0; i < size; ++i) {
            policies.put(in.readString(), new LifecyclePolicyMetadata(in));
        }
        this.policyMetadatas = policies;
        this.operationMode = (OperationMode)in.readEnum(OperationMode.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.policyMetadatas.size());
        for (Map.Entry<String, LifecyclePolicyMetadata> entry : this.policyMetadatas.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
        out.writeEnum((Enum)this.operationMode);
    }

    public Map<String, LifecyclePolicyMetadata> getPolicyMetadatas() {
        return this.policyMetadatas;
    }

    public OperationMode getOperationMode() {
        return this.operationMode;
    }

    public Map<String, LifecyclePolicy> getPolicies() {
        return this.policyMetadatas.values().stream().map(LifecyclePolicyMetadata::getPolicy).collect(Collectors.toMap(LifecyclePolicy::getName, Function.identity()));
    }

    public Diff<MetaData.Custom> diff(MetaData.Custom previousState) {
        return new IndexLifecycleMetadataDiff((IndexLifecycleMetadata)previousState, this);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(POLICIES_FIELD.getPreferredName(), this.policyMetadatas);
        builder.field(OPERATION_MODE_FIELD.getPreferredName(), (Object)this.operationMode);
        return builder;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_6_6_0;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public EnumSet<MetaData.XContentContext> context() {
        return MetaData.ALL_CONTEXTS;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policyMetadatas, this.operationMode});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        IndexLifecycleMetadata other = (IndexLifecycleMetadata)obj;
        return Objects.equals(this.policyMetadatas, other.policyMetadatas) && Objects.equals((Object)this.operationMode, (Object)other.operationMode);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> LifecyclePolicyMetadata.parse(p, n), v -> {
            throw new IllegalArgumentException("ordered " + POLICIES_FIELD.getPreferredName() + " are not supported");
        }, POLICIES_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), OPERATION_MODE_FIELD);
    }

    public static class IndexLifecycleMetadataDiff
    implements NamedDiff<MetaData.Custom> {
        final Diff<Map<String, LifecyclePolicyMetadata>> policies;
        final OperationMode operationMode;

        IndexLifecycleMetadataDiff(IndexLifecycleMetadata before, IndexLifecycleMetadata after) {
            this.policies = DiffableUtils.diff((Map)before.policyMetadatas, (Map)after.policyMetadatas, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
            this.operationMode = after.operationMode;
        }

        public IndexLifecycleMetadataDiff(StreamInput in) throws IOException {
            this.policies = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), LifecyclePolicyMetadata::new, IndexLifecycleMetadataDiff::readLifecyclePolicyDiffFrom);
            this.operationMode = (OperationMode)in.readEnum(OperationMode.class);
        }

        public MetaData.Custom apply(MetaData.Custom part) {
            TreeMap<String, LifecyclePolicyMetadata> newPolicies = new TreeMap<String, LifecyclePolicyMetadata>((Map)this.policies.apply((Object)((IndexLifecycleMetadata)part).policyMetadatas));
            return new IndexLifecycleMetadata(newPolicies, this.operationMode);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.policies.writeTo(out);
            out.writeEnum((Enum)this.operationMode);
        }

        public String getWriteableName() {
            return IndexLifecycleMetadata.TYPE;
        }

        static Diff<LifecyclePolicyMetadata> readLifecyclePolicyDiffFrom(StreamInput in) throws IOException {
            return AbstractDiffable.readDiffFrom(LifecyclePolicyMetadata::new, (StreamInput)in);
        }
    }
}

