/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class AllocationRoutedStep
extends ClusterStateWaitStep {
    public static final String NAME = "check-allocation";
    private static final Logger logger = LogManager.getLogger(AllocationRoutedStep.class);
    private static final AllocationDeciders ALLOCATION_DECIDERS = new AllocationDeciders(Collections.singletonList(new FilterAllocationDecider(Settings.EMPTY, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS))));

    AllocationRoutedStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        IndexMetaData idxMeta = clusterState.metaData().index(index);
        if (idxMeta == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return new ClusterStateWaitStep.Result(false, null);
        }
        if (!ActiveShardCount.ALL.enoughShardsActive(clusterState, new String[]{index.getName()})) {
            logger.debug("[{}] lifecycle action for index [{}] cannot make progress because not all shards are active", (Object)this.getKey().getAction(), (Object)index.getName());
            return new ClusterStateWaitStep.Result(false, new Info(idxMeta.getNumberOfReplicas(), -1L, false));
        }
        RoutingAllocation allocation = new RoutingAllocation(ALLOCATION_DECIDERS, clusterState.getRoutingNodes(), clusterState, null, System.nanoTime());
        int allocationPendingAllShards = 0;
        ImmutableOpenIntMap allShards = clusterState.getRoutingTable().index(index).getShards();
        for (ObjectCursor shardRoutingTable : allShards.values()) {
            for (ShardRouting shardRouting : ((IndexShardRoutingTable)shardRoutingTable.value).shards()) {
                boolean canRemainOnCurrentNode;
                String currentNodeId = shardRouting.currentNodeId();
                boolean bl = canRemainOnCurrentNode = ALLOCATION_DECIDERS.canRemain(shardRouting, clusterState.getRoutingNodes().node(currentNodeId), allocation).type() == Decision.Type.YES;
                if (canRemainOnCurrentNode && shardRouting.started()) continue;
                ++allocationPendingAllShards;
            }
        }
        if (allocationPendingAllShards > 0) {
            logger.debug("{} lifecycle action [{}] waiting for [{}] shards to be allocated to nodes matching the given filters", (Object)index, (Object)this.getKey().getAction(), (Object)allocationPendingAllShards);
            return new ClusterStateWaitStep.Result(false, new Info(idxMeta.getNumberOfReplicas(), allocationPendingAllShards, true));
        }
        logger.debug("{} lifecycle action for [{}] complete", (Object)index, (Object)this.getKey().getAction());
        return new ClusterStateWaitStep.Result(true, null);
    }

    @Override
    public int hashCode() {
        return 611;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return super.equals(obj);
    }

    public static final class Info
    implements ToXContentObject {
        private final long actualReplicas;
        private final long numberShardsLeftToAllocate;
        private final boolean allShardsActive;
        private final String message;
        static final ParseField ACTUAL_REPLICAS = new ParseField("actual_replicas", new String[0]);
        static final ParseField SHARDS_TO_ALLOCATE = new ParseField("shards_left_to_allocate", new String[0]);
        static final ParseField ALL_SHARDS_ACTIVE = new ParseField("all_shards_active", new String[0]);
        static final ParseField MESSAGE = new ParseField("message", new String[0]);
        static final ConstructingObjectParser<Info, Void> PARSER = new ConstructingObjectParser("allocation_routed_step_info", a -> new Info((Long)a[0], (Long)a[1], (Boolean)a[2]));

        public Info(long actualReplicas, long numberShardsLeftToAllocate, boolean allShardsActive) {
            this.actualReplicas = actualReplicas;
            this.numberShardsLeftToAllocate = numberShardsLeftToAllocate;
            this.allShardsActive = allShardsActive;
            this.message = !allShardsActive ? "Waiting for all shard copies to be active" : "Waiting for [" + numberShardsLeftToAllocate + "] shards to be allocated to nodes matching the given filters";
        }

        public long getActualReplicas() {
            return this.actualReplicas;
        }

        public long getNumberShardsLeftToAllocate() {
            return this.numberShardsLeftToAllocate;
        }

        public boolean allShardsActive() {
            return this.allShardsActive;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE.getPreferredName(), this.message);
            builder.field(SHARDS_TO_ALLOCATE.getPreferredName(), this.numberShardsLeftToAllocate);
            builder.field(ALL_SHARDS_ACTIVE.getPreferredName(), this.allShardsActive);
            builder.field(ACTUAL_REPLICAS.getPreferredName(), this.actualReplicas);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.actualReplicas, this.numberShardsLeftToAllocate, this.allShardsActive);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Info other = (Info)obj;
            return Objects.equals(this.actualReplicas, other.actualReplicas) && Objects.equals(this.numberShardsLeftToAllocate, other.numberShardsLeftToAllocate) && Objects.equals(this.allShardsActive, other.allShardsActive);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), ACTUAL_REPLICAS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SHARDS_TO_ALLOCATE);
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ALL_SHARDS_ACTIVE);
            PARSER.declareString((i, s) -> {}, MESSAGE);
        }
    }
}

