/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.deprecation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.deprecation.NodesDeprecationCheckAction;
import org.elasticsearch.xpack.core.deprecation.NodesDeprecationCheckResponse;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

public class DeprecationInfoAction
extends ActionType<Response> {
    public static final DeprecationInfoAction INSTANCE = new DeprecationInfoAction();
    public static final String NAME = "cluster:admin/xpack/deprecation/info";

    private DeprecationInfoAction() {
        super(NAME, Response::new);
    }

    public static <T> List<DeprecationIssue> filterChecks(List<T> checks, Function<T, DeprecationIssue> mapper) {
        return checks.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<DeprecationIssue> mergeNodeIssues(NodesDeprecationCheckResponse response) {
        HashMap<DeprecationIssue, List> issueListMap = new HashMap<DeprecationIssue, List>();
        for (NodesDeprecationCheckAction.NodeResponse resp : response.getNodes()) {
            for (DeprecationIssue issue : resp.getDeprecationIssues()) {
                issueListMap.computeIfAbsent(issue, key -> new ArrayList()).add(resp.getNode().getName());
            }
        }
        return issueListMap.entrySet().stream().map(entry -> {
            DeprecationIssue issue = (DeprecationIssue)entry.getKey();
            String details = issue.getDetails() != null ? issue.getDetails() + " " : "";
            return new DeprecationIssue(issue.getLevel(), issue.getMessage(), issue.getUrl(), details + "(nodes impacted: " + entry.getValue() + ")");
        }).collect(Collectors.toList());
    }

    public static class RequestBuilder
    extends MasterNodeReadOperationRequestBuilder<Request, Response, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, DeprecationInfoAction action) {
            super(client, (ActionType)action, (MasterNodeReadRequest)new Request());
        }

        public RequestBuilder setIndices(String ... indices) {
            ((Request)this.request).indices(indices);
            return this;
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] indices = Strings.EMPTY_ARRAY;
        private static final IndicesOptions INDICES_OPTIONS = IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true);

        public Request() {
        }

        public Request(String ... indices) {
            this.indices = indices;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.indices = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.indices);
        }

        public String[] indices() {
            return this.indices;
        }

        public Request indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public IndicesOptions indicesOptions() {
            return INDICES_OPTIONS;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indices == null) {
                validationException = ValidateActions.addValidationError((String)"index/indices is missing", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.indices, request.indices);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices));
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private List<DeprecationIssue> clusterSettingsIssues;
        private List<DeprecationIssue> nodeSettingsIssues;
        private Map<String, List<DeprecationIssue>> indexSettingsIssues;
        private List<DeprecationIssue> mlSettingsIssues;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.clusterSettingsIssues = in.readList(DeprecationIssue::new);
            this.nodeSettingsIssues = in.readList(DeprecationIssue::new);
            this.indexSettingsIssues = in.readMapOfLists(StreamInput::readString, DeprecationIssue::new);
            this.mlSettingsIssues = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readList(DeprecationIssue::new) : Collections.emptyList();
        }

        public Response(List<DeprecationIssue> clusterSettingsIssues, List<DeprecationIssue> nodeSettingsIssues, Map<String, List<DeprecationIssue>> indexSettingsIssues, List<DeprecationIssue> mlSettingsIssues) {
            this.clusterSettingsIssues = clusterSettingsIssues;
            this.nodeSettingsIssues = nodeSettingsIssues;
            this.indexSettingsIssues = indexSettingsIssues;
            this.mlSettingsIssues = mlSettingsIssues;
        }

        public List<DeprecationIssue> getClusterSettingsIssues() {
            return this.clusterSettingsIssues;
        }

        public List<DeprecationIssue> getNodeSettingsIssues() {
            return this.nodeSettingsIssues;
        }

        public Map<String, List<DeprecationIssue>> getIndexSettingsIssues() {
            return this.indexSettingsIssues;
        }

        public List<DeprecationIssue> getMlSettingsIssues() {
            return this.mlSettingsIssues;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.clusterSettingsIssues);
            out.writeList(this.nodeSettingsIssues);
            out.writeMapOfLists(this.indexSettingsIssues, StreamOutput::writeString, (o, v) -> v.writeTo(o));
            if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
                out.writeList(this.mlSettingsIssues);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().array("cluster_settings", this.clusterSettingsIssues.toArray()).array("node_settings", this.nodeSettingsIssues.toArray()).field("index_settings").map(this.indexSettingsIssues).array("ml_settings", this.mlSettingsIssues.toArray()).endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.clusterSettingsIssues, response.clusterSettingsIssues) && Objects.equals(this.nodeSettingsIssues, response.nodeSettingsIssues) && Objects.equals(this.indexSettingsIssues, response.indexSettingsIssues) && Objects.equals(this.mlSettingsIssues, response.mlSettingsIssues);
        }

        public int hashCode() {
            return Objects.hash(this.clusterSettingsIssues, this.nodeSettingsIssues, this.indexSettingsIssues, this.mlSettingsIssues);
        }

        public static Response from(ClusterState state, NamedXContentRegistry xContentRegistry, IndexNameExpressionResolver indexNameExpressionResolver, String[] indices, IndicesOptions indicesOptions, List<DatafeedConfig> datafeeds, NodesDeprecationCheckResponse nodeDeprecationResponse, List<Function<IndexMetaData, DeprecationIssue>> indexSettingsChecks, List<Function<ClusterState, DeprecationIssue>> clusterSettingsChecks, List<BiFunction<DatafeedConfig, NamedXContentRegistry, DeprecationIssue>> mlSettingsCheck) {
            List<DeprecationIssue> clusterSettingsIssues = DeprecationInfoAction.filterChecks(clusterSettingsChecks, c -> (DeprecationIssue)c.apply(state));
            List nodeSettingsIssues = DeprecationInfoAction.mergeNodeIssues(nodeDeprecationResponse);
            ArrayList<DeprecationIssue> mlSettingsIssues = new ArrayList<DeprecationIssue>();
            for (DatafeedConfig config : datafeeds) {
                mlSettingsIssues.addAll(DeprecationInfoAction.filterChecks(mlSettingsCheck, c -> (DeprecationIssue)c.apply(config, xContentRegistry)));
            }
            String[] concreteIndexNames = indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, indices);
            HashMap<String, List<DeprecationIssue>> indexSettingsIssues = new HashMap<String, List<DeprecationIssue>>();
            for (String concreteIndex : concreteIndexNames) {
                IndexMetaData indexMetaData = state.getMetaData().index(concreteIndex);
                List<DeprecationIssue> singleIndexIssues = DeprecationInfoAction.filterChecks(indexSettingsChecks, c -> (DeprecationIssue)c.apply(indexMetaData));
                if (singleIndexIssues.size() <= 0) continue;
                indexSettingsIssues.put(concreteIndex, singleIndexIssues);
            }
            return new Response(clusterSettingsIssues, nodeSettingsIssues, indexSettingsIssues, mlSettingsIssues);
        }
    }
}

