/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe.transforms;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.dataframe.transforms.QueryConfig;
import org.elasticsearch.xpack.core.dataframe.utils.ExceptionsHelper;

public class SourceConfig
implements Writeable,
ToXContentObject {
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    public static final ConstructingObjectParser<SourceConfig, Void> STRICT_PARSER = SourceConfig.createParser(false);
    public static final ConstructingObjectParser<SourceConfig, Void> LENIENT_PARSER = SourceConfig.createParser(true);
    private final String[] index;
    private final QueryConfig queryConfig;

    private static ConstructingObjectParser<SourceConfig, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser("data_frame_config_source", lenient, args -> {
            String[] index = ((List)args[0]).toArray(new String[0]);
            QueryConfig queryConfig = args[1] == null ? QueryConfig.matchAll() : (QueryConfig)((Object)((Object)args[1]));
            return new SourceConfig(index, queryConfig);
        });
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> QueryConfig.fromXContent(p, lenient), QUERY);
        return parser;
    }

    public SourceConfig(String ... index) {
        this(index, QueryConfig.matchAll());
    }

    public SourceConfig(String[] index, QueryConfig queryConfig) {
        ExceptionsHelper.requireNonNull(index, INDEX.getPreferredName());
        if (index.length == 0) {
            throw new IllegalArgumentException("must specify at least one index");
        }
        if (Arrays.stream(index).anyMatch(Strings::isNullOrEmpty)) {
            throw new IllegalArgumentException("all indices need to be non-null and non-empty");
        }
        this.index = index;
        this.queryConfig = ExceptionsHelper.requireNonNull(queryConfig, QUERY.getPreferredName());
    }

    public SourceConfig(StreamInput in) throws IOException {
        this.index = in.readStringArray();
        this.queryConfig = new QueryConfig(in);
    }

    public String[] getIndex() {
        return this.index;
    }

    public QueryConfig getQueryConfig() {
        return this.queryConfig;
    }

    public boolean isValid() {
        return this.queryConfig.isValid();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.index);
        this.queryConfig.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.array(INDEX.getPreferredName(), this.index);
        builder.field(QUERY.getPreferredName(), (ToXContent)this.queryConfig);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SourceConfig that = (SourceConfig)other;
        return Arrays.equals(this.index, that.index) && Objects.equals((Object)this.queryConfig, (Object)that.queryConfig);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(this.index);
        return 31 * hash + (this.queryConfig == null ? 0 : this.queryConfig.hashCode());
    }

    public static SourceConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (SourceConfig)LENIENT_PARSER.apply(parser, null) : (SourceConfig)STRICT_PARSER.apply(parser, null);
    }
}

