/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameIndexerTransformStats;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpointingInfo;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformState;

public class DataFrameTransformStoredDoc
implements Writeable,
ToXContentObject {
    public static final String NAME = "data_frame_transform_state_and_stats";
    public static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    private final String id;
    private final DataFrameTransformState transformState;
    private final DataFrameIndexerTransformStats transformStats;
    public static final ConstructingObjectParser<DataFrameTransformStoredDoc, Void> PARSER = new ConstructingObjectParser("data_frame_transform_state_and_stats", true, a -> new DataFrameTransformStoredDoc((String)a[0], (DataFrameTransformState)a[1], (DataFrameIndexerTransformStats)a[2]));

    public static DataFrameTransformStoredDoc fromXContent(XContentParser parser) throws IOException {
        return (DataFrameTransformStoredDoc)PARSER.parse(parser, null);
    }

    public static String documentId(String transformId) {
        return "data_frame_transform_state_and_stats-" + transformId;
    }

    public DataFrameTransformStoredDoc(String id, DataFrameTransformState state, DataFrameIndexerTransformStats stats) {
        this.id = Objects.requireNonNull(id);
        this.transformState = Objects.requireNonNull(state);
        this.transformStats = Objects.requireNonNull(stats);
    }

    public DataFrameTransformStoredDoc(StreamInput in) throws IOException {
        this.id = in.readString();
        this.transformState = new DataFrameTransformState(in);
        this.transformStats = new DataFrameIndexerTransformStats(in);
        if (in.getVersion().before(Version.V_7_4_0)) {
            new DataFrameTransformCheckpointingInfo(in);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DataFrameField.ID.getPreferredName(), this.id);
        builder.field(STATE_FIELD.getPreferredName(), (ToXContent)this.transformState, params);
        builder.field(DataFrameField.STATS_FIELD.getPreferredName(), (ToXContent)this.transformStats, params);
        builder.field(DataFrameField.INDEX_DOC_TYPE.getPreferredName(), NAME);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        this.transformState.writeTo(out);
        this.transformStats.writeTo(out);
        if (out.getVersion().before(Version.V_7_4_0)) {
            DataFrameTransformCheckpointingInfo.EMPTY.writeTo(out);
        }
    }

    public int hashCode() {
        return Objects.hash(this.id, this.transformState, this.transformStats);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformStoredDoc that = (DataFrameTransformStoredDoc)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.transformState, that.transformState) && Objects.equals(this.transformStats, that.transformStats);
    }

    public String getId() {
        return this.id;
    }

    public DataFrameIndexerTransformStats getTransformStats() {
        return this.transformStats;
    }

    public DataFrameTransformState getTransformState() {
        return this.transformState;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DataFrameField.ID);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> DataFrameTransformState.PARSER.apply(arg_0, arg_1), STATE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DataFrameIndexerTransformStats.fromXContent(p), DataFrameField.STATS_FIELD);
    }
}

