/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe.transforms;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameIndexerTransformStats;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpointingInfo;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformState;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformTaskState;
import org.elasticsearch.xpack.core.dataframe.transforms.NodeAttributes;
import org.elasticsearch.xpack.core.indexing.IndexerState;

public class DataFrameTransformStats
implements Writeable,
ToXContentObject {
    public static final String NAME = "data_frame_transform_stats";
    public static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    public static final ParseField REASON_FIELD = new ParseField("reason", new String[0]);
    public static final ParseField NODE_FIELD = new ParseField("node", new String[0]);
    public static final ParseField CHECKPOINTING_INFO_FIELD = new ParseField("checkpointing", new String[0]);
    private final String id;
    private final State state;
    @Nullable
    private final String reason;
    @Nullable
    private NodeAttributes node;
    private final DataFrameIndexerTransformStats indexerStats;
    private final DataFrameTransformCheckpointingInfo checkpointingInfo;
    public static final ConstructingObjectParser<DataFrameTransformStats, Void> PARSER = new ConstructingObjectParser("data_frame_transform_stats", true, a -> new DataFrameTransformStats((String)a[0], (State)((Object)((Object)a[1])), (String)a[2], (NodeAttributes)a[3], (DataFrameIndexerTransformStats)a[4], (DataFrameTransformCheckpointingInfo)a[5]));

    public static DataFrameTransformStats fromXContent(XContentParser parser) throws IOException {
        return (DataFrameTransformStats)PARSER.parse(parser, null);
    }

    public static DataFrameTransformStats initialStats(String id) {
        return DataFrameTransformStats.stoppedStats(id, new DataFrameIndexerTransformStats());
    }

    public static DataFrameTransformStats stoppedStats(String id, DataFrameIndexerTransformStats indexerTransformStats) {
        return new DataFrameTransformStats(id, State.STOPPED, null, null, indexerTransformStats, DataFrameTransformCheckpointingInfo.EMPTY);
    }

    public DataFrameTransformStats(String id, State state, @Nullable String reason, @Nullable NodeAttributes node, DataFrameIndexerTransformStats stats, DataFrameTransformCheckpointingInfo checkpointingInfo) {
        this.id = Objects.requireNonNull(id);
        this.state = Objects.requireNonNull(state);
        this.reason = reason;
        this.node = node;
        this.indexerStats = Objects.requireNonNull(stats);
        this.checkpointingInfo = Objects.requireNonNull(checkpointingInfo);
    }

    public DataFrameTransformStats(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_7_4_0)) {
            this.id = in.readString();
            this.state = (State)in.readEnum(State.class);
            this.reason = in.readOptionalString();
            this.node = in.readBoolean() ? new NodeAttributes(in) : null;
            this.indexerStats = new DataFrameIndexerTransformStats(in);
            this.checkpointingInfo = new DataFrameTransformCheckpointingInfo(in);
        } else {
            this.id = in.readString();
            DataFrameTransformState transformState = new DataFrameTransformState(in);
            this.state = State.fromComponents(transformState.getTaskState(), transformState.getIndexerState());
            this.reason = transformState.getReason();
            this.node = null;
            this.indexerStats = new DataFrameIndexerTransformStats(in);
            this.checkpointingInfo = new DataFrameTransformCheckpointingInfo(in);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DataFrameField.ID.getPreferredName(), this.id);
        builder.field(STATE_FIELD.getPreferredName(), this.state.value());
        if (this.reason != null) {
            builder.field(REASON_FIELD.getPreferredName(), this.reason);
        }
        if (this.node != null) {
            builder.field(NODE_FIELD.getPreferredName(), (ToXContent)this.node);
        }
        builder.field(DataFrameField.STATS_FIELD.getPreferredName(), (ToXContent)this.indexerStats, params);
        builder.field(CHECKPOINTING_INFO_FIELD.getPreferredName(), (ToXContent)this.checkpointingInfo, params);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeString(this.id);
            out.writeEnum((Enum)this.state);
            out.writeOptionalString(this.reason);
            if (this.node != null) {
                out.writeBoolean(true);
                this.node.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            this.indexerStats.writeTo(out);
            this.checkpointingInfo.writeTo(out);
        } else {
            out.writeString(this.id);
            Tuple<DataFrameTransformTaskState, IndexerState> stateComponents = this.state.toComponents();
            new DataFrameTransformState((DataFrameTransformTaskState)((Object)stateComponents.v1()), (IndexerState)((Object)stateComponents.v2()), this.checkpointingInfo.getNext().getPosition(), this.checkpointingInfo.getLast().getCheckpoint(), this.reason, this.checkpointingInfo.getNext().getCheckpointProgress()).writeTo(out);
            out.writeBoolean(false);
            this.indexerStats.writeTo(out);
            this.checkpointingInfo.writeTo(out);
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.reason, this.node, this.indexerStats, this.checkpointingInfo});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformStats that = (DataFrameTransformStats)other;
        return Objects.equals(this.id, that.id) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.reason, that.reason) && Objects.equals(this.node, that.node) && Objects.equals(this.indexerStats, that.indexerStats) && Objects.equals(this.checkpointingInfo, that.checkpointingInfo);
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Nullable
    public NodeAttributes getNode() {
        return this.node;
    }

    public void setNode(NodeAttributes node) {
        this.node = node;
    }

    public DataFrameIndexerTransformStats getIndexerStats() {
        return this.indexerStats;
    }

    public DataFrameTransformCheckpointingInfo getCheckpointingInfo() {
        return this.checkpointingInfo;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DataFrameField.ID);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> State.fromString(p.text()), STATE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> NodeAttributes.PARSER.apply(arg_0, arg_1), NODE_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DataFrameIndexerTransformStats.fromXContent(p), DataFrameField.STATS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DataFrameTransformCheckpointingInfo.fromXContent(p), CHECKPOINTING_INFO_FIELD);
    }

    public static final class State
    extends Enum<State>
    implements Writeable {
        public static final /* enum */ State STARTED = new State();
        public static final /* enum */ State INDEXING = new State();
        public static final /* enum */ State ABORTING = new State();
        public static final /* enum */ State STOPPING = new State();
        public static final /* enum */ State STOPPED = new State();
        public static final /* enum */ State FAILED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        public static State fromString(String name) {
            return State.valueOf(name.trim().toUpperCase(Locale.ROOT));
        }

        public static State fromStream(StreamInput in) throws IOException {
            return (State)in.readEnum(State.class);
        }

        public static State fromComponents(DataFrameTransformTaskState taskState, IndexerState indexerState) {
            if (taskState == null || taskState == DataFrameTransformTaskState.STOPPED) {
                return STOPPED;
            }
            if (taskState == DataFrameTransformTaskState.FAILED) {
                return FAILED;
            }
            assert (taskState == DataFrameTransformTaskState.STARTED);
            assert (indexerState != null);
            switch (indexerState) {
                case STARTED: {
                    return STARTED;
                }
                case INDEXING: {
                    return INDEXING;
                }
                case STOPPING: {
                    return STOPPING;
                }
                case STOPPED: {
                    return STOPPED;
                }
                case ABORTING: {
                    return ABORTING;
                }
            }
            throw new IllegalStateException("Unexpected indexer state enum value: " + (Object)((Object)indexerState));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public Tuple<DataFrameTransformTaskState, IndexerState> toComponents() {
            switch (this) {
                case STARTED: {
                    return new Tuple((Object)DataFrameTransformTaskState.STARTED, (Object)IndexerState.STARTED);
                }
                case INDEXING: {
                    return new Tuple((Object)DataFrameTransformTaskState.STARTED, (Object)IndexerState.INDEXING);
                }
                case ABORTING: {
                    return new Tuple((Object)DataFrameTransformTaskState.STARTED, (Object)IndexerState.ABORTING);
                }
                case STOPPING: {
                    return new Tuple((Object)DataFrameTransformTaskState.STARTED, (Object)IndexerState.STOPPING);
                }
                case STOPPED: {
                    return new Tuple((Object)DataFrameTransformTaskState.STOPPED, null);
                }
                case FAILED: {
                    return new Tuple((Object)DataFrameTransformTaskState.FAILED, null);
                }
            }
            throw new IllegalStateException("Unexpected state enum value: " + (Object)((Object)this));
        }

        static {
            $VALUES = new State[]{STARTED, INDEXING, ABORTING, STOPPING, STOPPED, FAILED};
        }
    }
}

