/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe.transforms;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpointStats;

public class DataFrameTransformCheckpointingInfo
implements Writeable,
ToXContentObject {
    public static final DataFrameTransformCheckpointingInfo EMPTY = new DataFrameTransformCheckpointingInfo(DataFrameTransformCheckpointStats.EMPTY, DataFrameTransformCheckpointStats.EMPTY, 0L, null);
    public static final ParseField LAST_CHECKPOINT = new ParseField("last", new String[0]);
    public static final ParseField NEXT_CHECKPOINT = new ParseField("next", new String[0]);
    public static final ParseField OPERATIONS_BEHIND = new ParseField("operations_behind", new String[0]);
    public static final ParseField CHANGES_LAST_DETECTED_AT = new ParseField("changes_last_detected_at", new String[0]);
    private final DataFrameTransformCheckpointStats last;
    private final DataFrameTransformCheckpointStats next;
    private final long operationsBehind;
    private Instant changesLastDetectedAt;
    private static final ConstructingObjectParser<DataFrameTransformCheckpointingInfo, Void> LENIENT_PARSER = new ConstructingObjectParser("data_frame_transform_checkpointing_info", true, a -> {
        long behind = a[2] == null ? 0L : (Long)a[2];
        Instant changesLastDetectedAt = (Instant)a[3];
        return new DataFrameTransformCheckpointingInfo(a[0] == null ? DataFrameTransformCheckpointStats.EMPTY : (DataFrameTransformCheckpointStats)a[0], a[1] == null ? DataFrameTransformCheckpointStats.EMPTY : (DataFrameTransformCheckpointStats)a[1], behind, changesLastDetectedAt);
    });

    public DataFrameTransformCheckpointingInfo(DataFrameTransformCheckpointStats last, DataFrameTransformCheckpointStats next, long operationsBehind, Instant changesLastDetectedAt) {
        this.last = Objects.requireNonNull(last);
        this.next = Objects.requireNonNull(next);
        this.operationsBehind = operationsBehind;
        this.changesLastDetectedAt = changesLastDetectedAt == null ? null : Instant.ofEpochMilli(changesLastDetectedAt.toEpochMilli());
    }

    public DataFrameTransformCheckpointingInfo(DataFrameTransformCheckpointStats last, DataFrameTransformCheckpointStats next, long operationsBehind) {
        this(last, next, operationsBehind, null);
    }

    public DataFrameTransformCheckpointingInfo(StreamInput in) throws IOException {
        this.last = new DataFrameTransformCheckpointStats(in);
        this.next = new DataFrameTransformCheckpointStats(in);
        this.operationsBehind = in.readLong();
        if (in.getVersion().onOrAfter(Version.V_7_4_0)) {
            this.changesLastDetectedAt = in.readOptionalInstant();
        }
    }

    public DataFrameTransformCheckpointStats getLast() {
        return this.last;
    }

    public DataFrameTransformCheckpointStats getNext() {
        return this.next;
    }

    public long getOperationsBehind() {
        return this.operationsBehind;
    }

    public Instant getChangesLastDetectedAt() {
        return this.changesLastDetectedAt;
    }

    public DataFrameTransformCheckpointingInfo setChangesLastDetectedAt(Instant changesLastDetectedAt) {
        this.changesLastDetectedAt = Instant.ofEpochMilli(Objects.requireNonNull(changesLastDetectedAt).toEpochMilli());
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LAST_CHECKPOINT.getPreferredName(), (ToXContent)this.last);
        if (this.next.getCheckpoint() > 0L) {
            builder.field(NEXT_CHECKPOINT.getPreferredName(), (ToXContent)this.next);
        }
        builder.field(OPERATIONS_BEHIND.getPreferredName(), this.operationsBehind);
        if (this.changesLastDetectedAt != null) {
            builder.timeField(CHANGES_LAST_DETECTED_AT.getPreferredName(), CHANGES_LAST_DETECTED_AT.getPreferredName() + "_string", this.changesLastDetectedAt.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.last.writeTo(out);
        this.next.writeTo(out);
        out.writeLong(this.operationsBehind);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeOptionalInstant(this.changesLastDetectedAt);
        }
    }

    public static DataFrameTransformCheckpointingInfo fromXContent(XContentParser p) {
        return (DataFrameTransformCheckpointingInfo)LENIENT_PARSER.apply(p, null);
    }

    public int hashCode() {
        return Objects.hash(this.last, this.next, this.operationsBehind, this.changesLastDetectedAt);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformCheckpointingInfo that = (DataFrameTransformCheckpointingInfo)other;
        return Objects.equals(this.last, that.last) && Objects.equals(this.next, that.next) && this.operationsBehind == that.operationsBehind && Objects.equals(this.changesLastDetectedAt, that.changesLastDetectedAt);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> DataFrameTransformCheckpointStats.LENIENT_PARSER.apply(arg_0, arg_1), LAST_CHECKPOINT);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> DataFrameTransformCheckpointStats.LENIENT_PARSER.apply(arg_0, arg_1), NEXT_CHECKPOINT);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), OPERATIONS_BEHIND);
        LENIENT_PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, CHANGES_LAST_DETECTED_AT.getPreferredName()), CHANGES_LAST_DETECTED_AT, ObjectParser.ValueType.VALUE);
    }
}

