/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe.transforms;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameIndexerPosition
implements Writeable,
ToXContentObject {
    public static final String NAME = "data_frame/indexer_position";
    public static final ParseField INDEXER_POSITION = new ParseField("indexer_position", new String[0]);
    public static final ParseField BUCKET_POSITION = new ParseField("bucket_position", new String[0]);
    private final Map<String, Object> indexerPosition;
    private final Map<String, Object> bucketPosition;
    public static final ConstructingObjectParser<DataFrameIndexerPosition, Void> PARSER = new ConstructingObjectParser("data_frame/indexer_position", true, args -> new DataFrameIndexerPosition((Map)args[0], (Map)args[1]));

    public DataFrameIndexerPosition(Map<String, Object> indexerPosition, Map<String, Object> bucketPosition) {
        this.indexerPosition = indexerPosition == null ? null : Collections.unmodifiableMap(indexerPosition);
        this.bucketPosition = bucketPosition == null ? null : Collections.unmodifiableMap(bucketPosition);
    }

    public DataFrameIndexerPosition(StreamInput in) throws IOException {
        Map position = in.readMap();
        this.indexerPosition = position == null ? null : Collections.unmodifiableMap(position);
        position = in.readMap();
        this.bucketPosition = position == null ? null : Collections.unmodifiableMap(position);
    }

    public Map<String, Object> getIndexerPosition() {
        return this.indexerPosition;
    }

    public Map<String, Object> getBucketsPosition() {
        return this.bucketPosition;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.indexerPosition);
        out.writeMap(this.bucketPosition);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.indexerPosition != null) {
            builder.field(INDEXER_POSITION.getPreferredName(), this.indexerPosition);
        }
        if (this.bucketPosition != null) {
            builder.field(BUCKET_POSITION.getPreferredName(), this.bucketPosition);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameIndexerPosition that = (DataFrameIndexerPosition)other;
        return Objects.equals(this.indexerPosition, that.indexerPosition) && Objects.equals(this.bucketPosition, that.bucketPosition);
    }

    public int hashCode() {
        return Objects.hash(this.indexerPosition, this.bucketPosition);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static DataFrameIndexerPosition fromXContent(XContentParser parser) {
        try {
            return (DataFrameIndexerPosition)PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), XContentParser::mapOrdered, INDEXER_POSITION, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), XContentParser::mapOrdered, BUCKET_POSITION, ObjectParser.ValueType.OBJECT);
    }
}

