/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.transforms;

import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformProgress;

public final class TransformProgressGatherer {
    public static void getInitialProgress(Client client, QueryBuilder filterQuery, DataFrameTransformConfig config, ActionListener<DataFrameTransformProgress> progressListener) {
        SearchRequest request = TransformProgressGatherer.getSearchRequest(config, filterQuery);
        ActionListener searchResponseActionListener = ActionListener.wrap(searchResponse -> progressListener.onResponse((Object)TransformProgressGatherer.searchResponseToDataFrameTransformProgressFunction().apply((SearchResponse)searchResponse)), arg_0 -> progressListener.onFailure(arg_0));
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"data_frame", (Client)client, (ActionType)SearchAction.INSTANCE, (ActionRequest)request, (ActionListener)searchResponseActionListener);
    }

    public static SearchRequest getSearchRequest(DataFrameTransformConfig config, QueryBuilder filteredQuery) {
        SearchRequest request = new SearchRequest(config.getSource().getIndex());
        request.allowPartialSearchResults(false);
        BoolQueryBuilder existsClauses = QueryBuilders.boolQuery();
        config.getPivotConfig().getGroupConfig().getGroups().values().forEach(src -> existsClauses.must((QueryBuilder)QueryBuilders.existsQuery((String)src.getField())));
        request.source(new SearchSourceBuilder().size(0).trackTotalHits(true).query((QueryBuilder)QueryBuilders.boolQuery().filter(filteredQuery).filter((QueryBuilder)existsClauses)));
        return request;
    }

    public static Function<SearchResponse, DataFrameTransformProgress> searchResponseToDataFrameTransformProgressFunction() {
        return searchResponse -> new DataFrameTransformProgress(Long.valueOf(searchResponse.getHits().getTotalHits().value), Long.valueOf(0L), Long.valueOf(0L));
    }
}

