/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.transforms;

import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.dataframe.DataFrameMessages;
import org.elasticsearch.xpack.core.dataframe.action.StartDataFrameTransformTaskAction;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameIndexerPosition;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameIndexerTransformStats;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransform;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpoint;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpointingInfo;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformProgress;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformState;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformStoredDoc;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformTaskState;
import org.elasticsearch.xpack.core.dataframe.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.dataframe.checkpoint.CheckpointProvider;
import org.elasticsearch.xpack.dataframe.checkpoint.DataFrameTransformsCheckpointService;
import org.elasticsearch.xpack.dataframe.notifications.DataFrameAuditor;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;
import org.elasticsearch.xpack.dataframe.transforms.DataFrameIndexer;
import org.elasticsearch.xpack.dataframe.transforms.TransformProgressGatherer;
import org.elasticsearch.xpack.dataframe.transforms.pivot.AggregationResultUtils;

public class DataFrameTransformTask
extends AllocatedPersistentTask
implements SchedulerEngine.Listener {
    private static final long SCHEDULER_NEXT_MILLISECONDS = 60000L;
    private static final Logger logger = LogManager.getLogger(DataFrameTransformTask.class);
    private static final int DEFAULT_FAILURE_RETRIES = 10;
    private volatile int numFailureRetries = 10;
    public static final Setting<Integer> NUM_FAILURE_RETRIES_SETTING = Setting.intSetting((String)"xpack.data_frame.num_transform_failure_retries", (int)10, (int)0, (int)100, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final IndexerState[] RUNNING_STATES = new IndexerState[]{IndexerState.STARTED, IndexerState.INDEXING};
    public static final String SCHEDULE_NAME = "data_frame/transforms/schedule";
    private final DataFrameTransform transform;
    private final SchedulerEngine schedulerEngine;
    private final ThreadPool threadPool;
    private final DataFrameAuditor auditor;
    private final DataFrameIndexerPosition initialPosition;
    private final IndexerState initialIndexerState;
    private volatile Instant changesLastDetectedAt;
    private final SetOnce<ClientDataFrameIndexer> indexer = new SetOnce();
    private final AtomicReference<DataFrameTransformTaskState> taskState;
    private final AtomicReference<String> stateReason;
    private final AtomicLong currentCheckpoint;

    public DataFrameTransformTask(long id, String type, String action, TaskId parentTask, DataFrameTransform transform, DataFrameTransformState state, SchedulerEngine schedulerEngine, DataFrameAuditor auditor, ThreadPool threadPool, Map<String, String> headers) {
        super(id, type, action, "data_frame_" + transform.getId(), parentTask, headers);
        this.transform = transform;
        this.schedulerEngine = schedulerEngine;
        this.threadPool = threadPool;
        this.auditor = auditor;
        IndexerState initialState = IndexerState.STOPPED;
        DataFrameTransformTaskState initialTaskState = DataFrameTransformTaskState.STOPPED;
        String initialReason = null;
        long initialGeneration = 0L;
        DataFrameIndexerPosition initialPosition = null;
        if (state != null) {
            initialTaskState = state.getTaskState();
            initialReason = state.getReason();
            IndexerState existingState = state.getIndexerState();
            initialState = existingState.equals((Object)IndexerState.INDEXING) ? IndexerState.STARTED : (existingState.equals((Object)IndexerState.ABORTING) || existingState.equals((Object)IndexerState.STOPPING) ? IndexerState.STOPPED : existingState);
            initialPosition = state.getPosition();
            initialGeneration = state.getCheckpoint();
        }
        this.initialIndexerState = initialState;
        this.initialPosition = initialPosition;
        this.currentCheckpoint = new AtomicLong(initialGeneration);
        this.taskState = new AtomicReference<DataFrameTransformTaskState>(initialTaskState);
        this.stateReason = new AtomicReference<String>(initialReason);
    }

    public String getTransformId() {
        return this.transform.getId();
    }

    public Task.Status getStatus() {
        return this.getState();
    }

    private ClientDataFrameIndexer getIndexer() {
        return (ClientDataFrameIndexer)((Object)this.indexer.get());
    }

    public DataFrameTransformState getState() {
        if (this.getIndexer() == null) {
            return new DataFrameTransformState(this.taskState.get(), this.initialIndexerState, this.initialPosition, this.currentCheckpoint.get(), this.stateReason.get(), null);
        }
        return new DataFrameTransformState(this.taskState.get(), ((ClientDataFrameIndexer)((Object)this.indexer.get())).getState(), (DataFrameIndexerPosition)((ClientDataFrameIndexer)((Object)this.indexer.get())).getPosition(), this.currentCheckpoint.get(), this.stateReason.get(), this.getIndexer().getProgress());
    }

    public DataFrameIndexerTransformStats getStats() {
        if (this.getIndexer() == null) {
            return new DataFrameIndexerTransformStats();
        }
        return (DataFrameIndexerTransformStats)this.getIndexer().getStats();
    }

    public long getCheckpoint() {
        return this.currentCheckpoint.get();
    }

    public void getCheckpointingInfo(DataFrameTransformsCheckpointService transformsCheckpointService, ActionListener<DataFrameTransformCheckpointingInfo> listener) {
        ClientDataFrameIndexer indexer = this.getIndexer();
        if (indexer == null) {
            transformsCheckpointService.getCheckpointingInfo(this.transform.getId(), this.currentCheckpoint.get(), this.initialPosition, null, listener);
            return;
        }
        indexer.getCheckpointProvider().getCheckpointingInfo(indexer.getLastCheckpoint(), indexer.getNextCheckpoint(), (DataFrameIndexerPosition)indexer.getPosition(), indexer.getProgress(), (ActionListener<DataFrameTransformCheckpointingInfo>)ActionListener.wrap(info -> {
            if (this.changesLastDetectedAt == null) {
                listener.onResponse(info);
            } else {
                listener.onResponse((Object)info.setChangesLastDetectedAt(this.changesLastDetectedAt));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public DataFrameTransformCheckpoint getLastCheckpoint() {
        return this.getIndexer().getLastCheckpoint();
    }

    public DataFrameTransformCheckpoint getNextCheckpoint() {
        return this.getIndexer().getNextCheckpoint();
    }

    public long getInProgressCheckpoint() {
        if (this.getIndexer() == null) {
            return 0L;
        }
        return ((ClientDataFrameIndexer)((Object)this.indexer.get())).getState().equals((Object)IndexerState.INDEXING) ? this.currentCheckpoint.get() + 1L : 0L;
    }

    public synchronized void setTaskStateStopped() {
        this.taskState.set(DataFrameTransformTaskState.STOPPED);
    }

    public synchronized void start(Long startingCheckpoint, boolean force, ActionListener<StartDataFrameTransformTaskAction.Response> listener) {
        logger.debug("[{}] start called with force [{}] and state [{}].", (Object)this.getTransformId(), (Object)force, (Object)this.getState());
        if (this.taskState.get() == DataFrameTransformTaskState.FAILED && !force) {
            listener.onFailure((Exception)new ElasticsearchStatusException(DataFrameMessages.getMessage((String)"Unable to start data frame transform [{0}] as it is in a failed state with failure: [{1}]. Use force start to restart data frame transform once error is resolved.", (Object[])new Object[]{this.getTransformId(), this.stateReason.get()}), RestStatus.CONFLICT, new Object[0]));
            return;
        }
        if (this.getIndexer() == null) {
            String msg = this.taskState.get() == DataFrameTransformTaskState.FAILED ? "It failed during the initialization process; force stop to allow reinitialization." : "Try again later.";
            listener.onFailure((Exception)new ElasticsearchStatusException("Task for transform [{}] not fully initialized. {}", RestStatus.CONFLICT, new Object[]{this.getTransformId(), msg}));
            return;
        }
        IndexerState newState = this.getIndexer().start();
        if (Arrays.stream(RUNNING_STATES).noneMatch(arg_0 -> newState.equals(arg_0))) {
            listener.onFailure((Exception)new ElasticsearchException("Cannot start task for data frame transform [{}], because state was [{}]", new Object[]{this.transform.getId(), newState}));
            return;
        }
        this.stateReason.set(null);
        this.taskState.set(DataFrameTransformTaskState.STARTED);
        if (startingCheckpoint != null) {
            this.currentCheckpoint.set(startingCheckpoint);
        }
        DataFrameTransformState state = new DataFrameTransformState(DataFrameTransformTaskState.STARTED, IndexerState.STOPPED, (DataFrameIndexerPosition)this.getIndexer().getPosition(), this.currentCheckpoint.get(), null, this.getIndexer().getProgress());
        logger.info("[{}] updating state for data frame transform to [{}].", (Object)this.transform.getId(), (Object)state.toString());
        this.persistStateToClusterState(state, ActionListener.wrap(task -> {
            this.auditor.info(this.transform.getId(), "Updated data frame transform state to [" + state.getTaskState() + "].");
            long now = System.currentTimeMillis();
            this.triggered(new SchedulerEngine.Event(this.schedulerJobName(), now, now));
            this.registerWithSchedulerJob();
            listener.onResponse((Object)new StartDataFrameTransformTaskAction.Response(true));
        }, exc -> {
            this.auditor.warning(this.transform.getId(), "Failed to persist to cluster state while marking task as started. Failure: " + exc.getMessage());
            logger.error((Message)new ParameterizedMessage("[{}] failed updating state to [{}].", (Object)this.getTransformId(), (Object)state), (Throwable)exc);
            this.getIndexer().stop();
            listener.onFailure((Exception)new ElasticsearchException("Error while updating state for data frame transform [" + this.transform.getId() + "] to [" + state.getIndexerState() + "].", (Throwable)exc, new Object[0]));
        }));
    }

    public synchronized void stop(boolean force) {
        logger.debug("[{}] stop called with force [{}] and state [{}]", (Object)this.getTransformId(), (Object)force, (Object)this.getState());
        if (this.getIndexer() == null) {
            this.shutdown();
            return;
        }
        if (this.getIndexer().getState() == IndexerState.STOPPED) {
            return;
        }
        if (this.taskState.get() == DataFrameTransformTaskState.FAILED && !force) {
            throw new ElasticsearchStatusException(DataFrameMessages.getMessage((String)"Unable to stop data frame transform [{0}] as it is in a failed state with reason [{1}]. Use force stop to stop the data frame transform.", (Object[])new Object[]{this.getTransformId(), this.stateReason.get()}), RestStatus.CONFLICT, new Object[0]);
        }
        IndexerState state = this.getIndexer().stop();
        this.stateReason.set(null);
        this.taskState.set(DataFrameTransformTaskState.STARTED);
        if (state == IndexerState.STOPPED) {
            this.getIndexer().onStop();
            this.getIndexer().doSaveState(state, (DataFrameIndexerPosition)this.getIndexer().getPosition(), () -> {});
        }
    }

    public synchronized void triggered(SchedulerEngine.Event event) {
        if (!event.getJobName().equals(this.schedulerJobName())) {
            return;
        }
        if (this.getIndexer() == null) {
            logger.warn("[{}] data frame task triggered with an unintialized indexer.", (Object)this.getTransformId());
            return;
        }
        if (this.taskState.get() == DataFrameTransformTaskState.FAILED) {
            logger.debug("[{}] schedule was triggered for transform but task is failed. Ignoring trigger.", (Object)this.getTransformId());
            return;
        }
        IndexerState indexerState = this.getIndexer().getState();
        if (IndexerState.INDEXING.equals((Object)indexerState) || IndexerState.STOPPING.equals((Object)indexerState) || IndexerState.STOPPED.equals((Object)indexerState)) {
            logger.debug("[{}] indexer for transform has state [{}]. Ignoring trigger.", (Object)this.getTransformId(), (Object)indexerState);
            return;
        }
        logger.debug("[{}] data frame indexer schedule has triggered, state: [{}].", (Object)event.getJobName(), (Object)indexerState);
        if (this.currentCheckpoint.get() == 0L) {
            logger.debug("Trigger initial run.");
            this.getIndexer().maybeTriggerAsyncJob(System.currentTimeMillis());
        } else if (this.getIndexer().isContinuous()) {
            this.getIndexer().maybeTriggerAsyncJob(System.currentTimeMillis());
        }
    }

    synchronized void shutdown() {
        this.deregisterSchedulerJob();
        this.markAsCompleted();
    }

    public DataFrameTransformProgress getProgress() {
        if (this.indexer.get() == null) {
            return null;
        }
        DataFrameTransformProgress indexerProgress = ((ClientDataFrameIndexer)((Object)this.indexer.get())).getProgress();
        if (indexerProgress == null) {
            return null;
        }
        return new DataFrameTransformProgress(indexerProgress);
    }

    void persistStateToClusterState(DataFrameTransformState state, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        this.updatePersistentTaskState((PersistentTaskState)state, ActionListener.wrap(success -> {
            logger.debug("[{}] successfully updated state for data frame transform to [{}].", (Object)this.transform.getId(), (Object)state.toString());
            listener.onResponse(success);
        }, failure -> {
            logger.error((Message)new ParameterizedMessage("[{}] failed to update cluster state for data frame transform.", (Object)this.transform.getId()), (Throwable)failure);
            listener.onFailure(failure);
        }));
    }

    synchronized void markAsFailed(String reason, ActionListener<Void> listener) {
        if (this.taskState.get() == DataFrameTransformTaskState.FAILED) {
            logger.warn("[{}] is already failed but encountered new failure; reason [{}].", (Object)this.getTransformId(), (Object)reason);
            listener.onResponse(null);
            return;
        }
        if (this.getIndexer() != null && this.getIndexer().getState() == IndexerState.STOPPING) {
            logger.info("[{}] attempt to fail transform with reason [{}] while it was stopping.", (Object)this.getTransformId(), (Object)reason);
            listener.onResponse(null);
            return;
        }
        if (this.getIndexer() != null && this.getIndexer().getState() == IndexerState.STOPPED) {
            logger.info("[{}] encountered a failure but indexer is STOPPED; reason [{}].", (Object)this.getTransformId(), (Object)reason);
            listener.onResponse(null);
            return;
        }
        this.auditor.error(this.transform.getId(), reason);
        this.deregisterSchedulerJob();
        this.taskState.set(DataFrameTransformTaskState.FAILED);
        this.stateReason.set(reason);
        DataFrameTransformState newState = this.getState();
        this.persistStateToClusterState(newState, ActionListener.wrap(r -> listener.onResponse(null), e -> {
            String msg = "Failed to persist to cluster state while marking task as failed with reason [" + reason + "].";
            this.auditor.warning(this.transform.getId(), msg + " Failure: " + e.getMessage());
            logger.error((Message)new ParameterizedMessage("[{}] {}", (Object)this.getTransformId(), (Object)msg), (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public synchronized void onCancelled() {
        logger.info("[{}] received cancellation request for data frame transform, state: [{}].", (Object)this.getTransformId(), (Object)this.taskState.get());
        if (this.getIndexer() != null && this.getIndexer().abort()) {
            this.shutdown();
        }
    }

    public DataFrameTransformTask setNumFailureRetries(int numFailureRetries) {
        this.numFailureRetries = numFailureRetries;
        return this;
    }

    public int getNumFailureRetries() {
        return this.numFailureRetries;
    }

    private void registerWithSchedulerJob() {
        this.schedulerEngine.register((SchedulerEngine.Listener)this);
        SchedulerEngine.Job schedulerJob = new SchedulerEngine.Job(this.schedulerJobName(), this.next());
        this.schedulerEngine.add(schedulerJob);
    }

    private void deregisterSchedulerJob() {
        this.schedulerEngine.remove(this.schedulerJobName());
        this.schedulerEngine.unregister((SchedulerEngine.Listener)this);
    }

    private String schedulerJobName() {
        return "data_frame/transforms/schedule_" + this.getTransformId();
    }

    private SchedulerEngine.Schedule next() {
        return (startTime, now) -> {
            TimeValue frequency = this.transform.getFrequency();
            return now + (frequency == null ? 60000L : frequency.getMillis());
        };
    }

    synchronized void initializeIndexer(ClientDataFrameIndexerBuilder indexerBuilder) {
        this.indexer.set((Object)indexerBuilder.build(this));
    }

    private static class TransformConfigReloadingException
    extends ElasticsearchException {
        TransformConfigReloadingException(String msg, Throwable cause, Object ... args) {
            super(msg, cause, args);
        }
    }

    private static class BulkIndexingException
    extends ElasticsearchException {
        BulkIndexingException(String msg, Object ... args) {
            super(msg, args);
        }
    }

    static class ClientDataFrameIndexer
    extends DataFrameIndexer {
        private long logEvery = 1L;
        private long logCount = 0L;
        private final Client client;
        private final DataFrameTransformsConfigManager transformsConfigManager;
        private final CheckpointProvider checkpointProvider;
        private final String transformId;
        private final DataFrameTransformTask transformTask;
        private final AtomicInteger failureCount;
        private volatile boolean auditBulkFailures = true;
        private volatile boolean hasSourceChanged = true;
        private volatile String lastAuditedExceptionMessage = null;
        private final AtomicBoolean oldStatsCleanedUp = new AtomicBoolean(false);

        ClientDataFrameIndexer(String transformId, DataFrameTransformsConfigManager transformsConfigManager, CheckpointProvider checkpointProvider, AtomicReference<IndexerState> initialState, DataFrameIndexerPosition initialPosition, Client client, DataFrameAuditor auditor, DataFrameIndexerTransformStats initialStats, DataFrameTransformConfig transformConfig, Map<String, String> fieldMappings, DataFrameTransformProgress transformProgress, DataFrameTransformCheckpoint lastCheckpoint, DataFrameTransformCheckpoint nextCheckpoint, DataFrameTransformTask parentTask) {
            super(((DataFrameTransformTask)((Object)ExceptionsHelper.requireNonNull((Object)((Object)parentTask), (String)"parentTask"))).threadPool.executor("generic"), (DataFrameAuditor)((Object)ExceptionsHelper.requireNonNull((Object)((Object)auditor), (String)"auditor")), transformConfig, fieldMappings, (AtomicReference)ExceptionsHelper.requireNonNull(initialState, (String)"initialState"), initialPosition, initialStats == null ? new DataFrameIndexerTransformStats() : initialStats, transformProgress, lastCheckpoint, nextCheckpoint);
            this.transformId = (String)ExceptionsHelper.requireNonNull((Object)transformId, (String)"transformId");
            this.transformsConfigManager = (DataFrameTransformsConfigManager)ExceptionsHelper.requireNonNull((Object)transformsConfigManager, (String)"transformsConfigManager");
            this.checkpointProvider = (CheckpointProvider)ExceptionsHelper.requireNonNull((Object)checkpointProvider, (String)"checkpointProvider");
            this.client = (Client)ExceptionsHelper.requireNonNull((Object)client, (String)"client");
            this.transformTask = parentTask;
            this.failureCount = new AtomicInteger(0);
        }

        @Override
        protected void onStart(long now, ActionListener<Boolean> listener) {
            if (this.transformTask.taskState.get() == DataFrameTransformTaskState.FAILED) {
                logger.debug("[{}] attempted to start while failed.", (Object)this.transformId);
                listener.onFailure((Exception)new ElasticsearchException("Attempted to start a failed transform [{}].", new Object[]{this.transformId}));
                return;
            }
            ActionListener updateConfigListener = ActionListener.wrap(updateConfigResponse -> {
                if (this.initialRun()) {
                    this.createCheckpoint((ActionListener<DataFrameTransformCheckpoint>)ActionListener.wrap(cp -> {
                        this.nextCheckpoint = cp;
                        if (this.nextCheckpoint.getCheckpoint() > 1L) {
                            this.progress = new DataFrameTransformProgress(null, Long.valueOf(0L), Long.valueOf(0L));
                            super.onStart(now, listener);
                            return;
                        }
                        TransformProgressGatherer.getInitialProgress(this.client, this.buildFilterQuery(), this.getConfig(), (ActionListener<DataFrameTransformProgress>)ActionListener.wrap(newProgress -> {
                            logger.trace("[{}] reset the progress from [{}] to [{}].", (Object)this.transformId, (Object)this.progress, newProgress);
                            this.progress = newProgress;
                            super.onStart(now, listener);
                        }, failure -> {
                            this.progress = null;
                            logger.warn((Message)new ParameterizedMessage("[{}] unable to load progress information for task.", (Object)this.transformId), (Throwable)failure);
                            super.onStart(now, listener);
                        }));
                    }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                } else {
                    super.onStart(now, listener);
                }
            }, arg_0 -> listener.onFailure(arg_0));
            ActionListener changedSourceListener = ActionListener.wrap(r -> {
                if (this.isContinuous()) {
                    this.transformsConfigManager.getTransformConfiguration(this.getJobId(), (ActionListener<DataFrameTransformConfig>)ActionListener.wrap(config -> {
                        this.transformConfig = config;
                        logger.debug("[{}] successfully refreshed data frame transform config from index.", (Object)this.transformId);
                        updateConfigListener.onResponse(null);
                    }, failure -> {
                        String msg = DataFrameMessages.getMessage((String)"Failed to reload data frame transform configuration for transform [{0}]", (Object[])new Object[]{this.getJobId()});
                        logger.error(msg, (Throwable)failure);
                        if (failure instanceof ResourceNotFoundException) {
                            updateConfigListener.onFailure((Exception)((Object)new TransformConfigReloadingException(msg, (Throwable)failure, new Object[0])));
                        } else {
                            this.auditor.warning(this.getJobId(), msg);
                            updateConfigListener.onResponse(null);
                        }
                    }));
                } else {
                    updateConfigListener.onResponse(null);
                }
            }, arg_0 -> listener.onFailure(arg_0));
            if (this.transformTask.currentCheckpoint.get() > 0L && this.initialRun()) {
                this.sourceHasChanged((ActionListener<Boolean>)ActionListener.wrap(hasChanged -> {
                    this.hasSourceChanged = hasChanged;
                    if (hasChanged.booleanValue()) {
                        this.transformTask.changesLastDetectedAt = Instant.now();
                        logger.debug("[{}] source has changed, triggering new indexer run.", (Object)this.transformId);
                        changedSourceListener.onResponse(null);
                    } else {
                        logger.trace("[{}] source has not changed, finish indexer early.", (Object)this.transformId);
                        listener.onResponse((Object)false);
                    }
                }, failure -> {
                    this.hasSourceChanged = true;
                    listener.onFailure(failure);
                }));
            } else {
                this.hasSourceChanged = true;
                changedSourceListener.onResponse(null);
            }
        }

        protected String getJobId() {
            return this.transformId;
        }

        public CheckpointProvider getCheckpointProvider() {
            return this.checkpointProvider;
        }

        public synchronized boolean maybeTriggerAsyncJob(long now) {
            if (this.transformTask.taskState.get() == DataFrameTransformTaskState.FAILED) {
                logger.debug("[{}] schedule was triggered for transform but task is failed. Ignoring trigger.", (Object)this.getJobId());
                return false;
            }
            IndexerState indexerState = this.getState();
            if (IndexerState.INDEXING.equals((Object)indexerState) || IndexerState.STOPPING.equals((Object)indexerState)) {
                logger.debug("[{}] indexer for transform has state [{}]. Ignoring trigger.", (Object)this.getJobId(), (Object)indexerState);
                return false;
            }
            return super.maybeTriggerAsyncJob(now);
        }

        protected void doNextSearch(SearchRequest request, ActionListener<SearchResponse> nextPhase) {
            if (this.transformTask.taskState.get() == DataFrameTransformTaskState.FAILED) {
                logger.debug("[{}] attempted to search while failed.", (Object)this.transformId);
                nextPhase.onFailure((Exception)new ElasticsearchException("Attempted to do a search request for failed transform [{}].", new Object[]{this.transformId}));
                return;
            }
            ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"data_frame", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)request, nextPhase);
        }

        protected void doNextBulk(BulkRequest request, ActionListener<BulkResponse> nextPhase) {
            if (this.transformTask.taskState.get() == DataFrameTransformTaskState.FAILED) {
                logger.debug("[{}] attempted to bulk index while failed.", (Object)this.transformId);
                nextPhase.onFailure((Exception)new ElasticsearchException("Attempted to do a bulk index request for failed transform [{}].", new Object[]{this.transformId}));
                return;
            }
            ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"data_frame", (Client)this.client, (ActionType)BulkAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(bulkResponse -> {
                if (bulkResponse.hasFailures()) {
                    int failureCount = 0;
                    for (BulkItemResponse item : bulkResponse.getItems()) {
                        if (!item.isFailed()) continue;
                        ++failureCount;
                    }
                    if (this.auditBulkFailures) {
                        this.auditor.warning(this.transformId, "Experienced at least [" + failureCount + "] bulk index failures. See the logs of the node running the transform for details. " + bulkResponse.buildFailureMessage());
                        this.auditBulkFailures = false;
                    }
                    nextPhase.onFailure((Exception)((Object)new BulkIndexingException("Bulk index experienced failures. See the logs of the node running the transform for details.", new Object[0])));
                } else {
                    this.auditBulkFailures = true;
                    nextPhase.onResponse(bulkResponse);
                }
            }, arg_0 -> nextPhase.onFailure(arg_0)));
        }

        protected void doSaveState(IndexerState indexerState, DataFrameIndexerPosition position, Runnable next) {
            if (this.transformTask.taskState.get() == DataFrameTransformTaskState.FAILED) {
                logger.debug("[{}] attempted to save state and stats while failed.", (Object)this.transformId);
                next.run();
                return;
            }
            if (indexerState.equals((Object)IndexerState.ABORTING)) {
                next.run();
                return;
            }
            if (!this.hasSourceChanged && !indexerState.equals((Object)IndexerState.STOPPED)) {
                next.run();
                return;
            }
            if (indexerState.equals((Object)IndexerState.STOPPED)) {
                this.transformTask.setTaskStateStopped();
            }
            DataFrameTransformTaskState taskState = (DataFrameTransformTaskState)this.transformTask.taskState.get();
            if (indexerState.equals((Object)IndexerState.STARTED) && this.transformTask.currentCheckpoint.get() == 1L && !this.isContinuous()) {
                taskState = DataFrameTransformTaskState.STOPPED;
                indexerState = IndexerState.STOPPED;
                this.auditor.info(this.transformConfig.getId(), "Data frame finished indexing all data, initiating stop");
                logger.info("[{}] data frame transform finished indexing all data, initiating stop.", (Object)this.transformConfig.getId());
            }
            DataFrameTransformState state = new DataFrameTransformState(taskState, indexerState, position, this.transformTask.currentCheckpoint.get(), (String)this.transformTask.stateReason.get(), this.getProgress());
            logger.debug("[{}] updating persistent state of transform to [{}].", (Object)this.transformConfig.getId(), (Object)state.toString());
            this.transformsConfigManager.putOrUpdateTransformStoredDoc(new DataFrameTransformStoredDoc(this.transformId, state, (DataFrameIndexerTransformStats)this.getStats()), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                if (state.getTaskState().equals((Object)DataFrameTransformTaskState.STOPPED)) {
                    this.transformTask.shutdown();
                }
                if (this.oldStatsCleanedUp.compareAndSet(false, true)) {
                    this.transformsConfigManager.deleteOldTransformStoredDocuments(this.transformId, (ActionListener<Boolean>)ActionListener.wrap(nil -> {
                        logger.trace("[{}] deleted old transform stats and state document", (Object)this.transformId);
                        next.run();
                    }, e -> {
                        String msg = LoggerMessageFormat.format((String)"[{}] failed deleting old transform configurations.", (String)this.transformId, (Object[])new Object[0]);
                        logger.warn(msg, (Throwable)e);
                        this.oldStatsCleanedUp.set(false);
                        next.run();
                    }));
                } else {
                    next.run();
                }
            }, statsExc -> {
                logger.error((Message)new ParameterizedMessage("[{}] updating stats of transform failed.", (Object)this.transformConfig.getId()), (Throwable)statsExc);
                this.auditor.warning(this.getJobId(), "Failure updating stats of transform: " + statsExc.getMessage());
                if (state.getTaskState().equals((Object)DataFrameTransformTaskState.STOPPED)) {
                    this.transformTask.shutdown();
                }
                next.run();
            }));
        }

        protected void onFailure(Exception exc) {
            try {
                this.handleFailure(exc);
            }
            catch (Exception e) {
                logger.error((Message)new ParameterizedMessage("[{}] data frame transform encountered an unexpected internal exception: ", (Object)this.transformId), (Throwable)e);
            }
        }

        @Override
        protected void onFinish(ActionListener<Void> listener) {
            try {
                if (!this.hasSourceChanged) {
                    listener.onResponse(null);
                    return;
                }
                super.onFinish(listener);
                long checkpoint = this.transformTask.currentCheckpoint.getAndIncrement();
                this.lastCheckpoint = this.getNextCheckpoint();
                this.nextCheckpoint = null;
                this.failureCount.set(0);
                if (this.progress != null && this.progress.getPercentComplete() != null && this.progress.getPercentComplete() < 100.0) {
                    this.progress.incrementDocsProcessed(this.progress.getTotalDocs() - this.progress.getDocumentsProcessed());
                }
                if (this.lastCheckpoint != null && this.lastCheckpoint.getCheckpoint() > 1L) {
                    long docsIndexed = 0L;
                    long docsProcessed = 0L;
                    if (this.progress != null) {
                        docsIndexed = this.progress.getDocumentsIndexed();
                        docsProcessed = this.progress.getDocumentsProcessed();
                    }
                    long durationMs = System.currentTimeMillis() - this.lastCheckpoint.getTimestamp();
                    ((DataFrameIndexerTransformStats)this.getStats()).incrementCheckpointExponentialAverages(durationMs < 0L ? 0L : durationMs, docsIndexed, docsProcessed);
                }
                if (this.shouldAuditOnFinish(checkpoint)) {
                    this.auditor.info(this.transformTask.getTransformId(), "Finished indexing for data frame transform checkpoint [" + checkpoint + "].");
                }
                logger.debug("[{}] finished indexing for data frame transform checkpoint [{}].", (Object)this.getJobId(), (Object)checkpoint);
                this.auditBulkFailures = true;
                listener.onResponse(null);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }

        protected boolean shouldAuditOnFinish(long completedCheckpoint) {
            if (++this.logCount % this.logEvery != 0L) {
                return false;
            }
            if (completedCheckpoint == 0L) {
                return true;
            }
            int log10Checkpoint = (int)Math.floor(Math.log10(completedCheckpoint));
            this.logEvery = log10Checkpoint >= 3 ? 1000L : (long)((int)Math.pow(10.0, log10Checkpoint));
            this.logCount = 0L;
            return true;
        }

        protected void onStop() {
            this.auditor.info(this.transformConfig.getId(), "Data frame transform has stopped.");
            logger.info("[{}] data frame transform has stopped.", (Object)this.transformConfig.getId());
        }

        protected void onAbort() {
            this.auditor.info(this.transformConfig.getId(), "Received abort request, stopping data frame transform.");
            logger.info("[{}] data frame transform received abort request. Stopping indexer.", (Object)this.transformConfig.getId());
            this.transformTask.shutdown();
        }

        @Override
        protected void createCheckpoint(ActionListener<DataFrameTransformCheckpoint> listener) {
            this.checkpointProvider.createNextCheckpoint(this.getLastCheckpoint(), (ActionListener<DataFrameTransformCheckpoint>)ActionListener.wrap(checkpoint -> this.transformsConfigManager.putTransformCheckpoint((DataFrameTransformCheckpoint)checkpoint, (ActionListener<Boolean>)ActionListener.wrap(putCheckPointResponse -> listener.onResponse(checkpoint), createCheckpointException -> {
                logger.warn((Message)new ParameterizedMessage("[{}] failed to create checkpoint.", (Object)this.transformId), (Throwable)createCheckpointException);
                listener.onFailure((Exception)new RuntimeException("Failed to create checkpoint due to " + createCheckpointException.getMessage(), (Throwable)createCheckpointException));
            })), getCheckPointException -> {
                logger.warn((Message)new ParameterizedMessage("[{}] failed to retrieve checkpoint.", (Object)this.transformId), (Throwable)getCheckPointException);
                listener.onFailure((Exception)new RuntimeException("Failed to retrieve checkpoint due to " + getCheckPointException.getMessage(), (Throwable)getCheckPointException));
            }));
        }

        @Override
        protected void sourceHasChanged(ActionListener<Boolean> hasChangedListener) {
            this.checkpointProvider.sourceHasChanged(this.getLastCheckpoint(), (ActionListener<Boolean>)ActionListener.wrap(hasChanged -> {
                logger.trace("[{}] change detected [{}].", (Object)this.transformId, hasChanged);
                hasChangedListener.onResponse(hasChanged);
            }, e -> {
                logger.warn((Message)new ParameterizedMessage("[{}] failed to detect changes for data frame transform. Skipping update till next check.", (Object)this.transformId), (Throwable)e);
                this.auditor.warning(this.transformId, "Failed to detect changes for data frame transform, skipping update till next check. Exception: " + e.getMessage());
                hasChangedListener.onResponse((Object)false);
            }));
        }

        private boolean isIrrecoverableFailure(Exception e) {
            return e instanceof IndexNotFoundException || e instanceof AggregationResultUtils.AggregationExtractionException || e instanceof TransformConfigReloadingException;
        }

        synchronized void handleFailure(Exception e) {
            logger.warn((Message)new ParameterizedMessage("[{}] data frame transform encountered an exception: ", (Object)this.transformTask.getTransformId()), (Throwable)e);
            if (this.handleCircuitBreakingException(e)) {
                return;
            }
            if (this.isIrrecoverableFailure(e) || this.failureCount.incrementAndGet() > this.transformTask.getNumFailureRetries()) {
                String failureMessage = this.isIrrecoverableFailure(e) ? "task encountered irrecoverable failure: " + e.getMessage() : "task encountered more than " + this.transformTask.getNumFailureRetries() + " failures; latest failure: " + e.getMessage();
                this.failIndexer(failureMessage);
            } else if (!e.getMessage().equals(this.lastAuditedExceptionMessage)) {
                this.auditor.warning(this.transformTask.getTransformId(), "Data frame transform encountered an exception: " + e.getMessage() + " Will attempt again at next scheduled trigger.");
                this.lastAuditedExceptionMessage = e.getMessage();
            }
        }

        @Override
        protected void failIndexer(String failureMessage) {
            logger.error("[{}] transform has failed; experienced: [{}].", (Object)this.getJobId(), (Object)failureMessage);
            this.auditor.error(this.transformTask.getTransformId(), failureMessage);
            this.transformTask.markAsFailed(failureMessage, (ActionListener<Void>)ActionListener.wrap(r -> this.failureCount.set(0), e -> {}));
        }
    }

    static class ClientDataFrameIndexerBuilder {
        private Client client;
        private DataFrameTransformsConfigManager transformsConfigManager;
        private DataFrameTransformsCheckpointService transformsCheckpointService;
        private String transformId;
        private DataFrameAuditor auditor;
        private Map<String, String> fieldMappings;
        private DataFrameTransformConfig transformConfig;
        private DataFrameIndexerTransformStats initialStats;
        private IndexerState indexerState = IndexerState.STOPPED;
        private DataFrameIndexerPosition initialPosition;
        private DataFrameTransformProgress progress;
        private DataFrameTransformCheckpoint lastCheckpoint;
        private DataFrameTransformCheckpoint nextCheckpoint;

        ClientDataFrameIndexerBuilder(String transformId) {
            this.transformId = transformId;
            this.initialStats = new DataFrameIndexerTransformStats();
        }

        ClientDataFrameIndexer build(DataFrameTransformTask parentTask) {
            CheckpointProvider checkpointProvider = this.transformsCheckpointService.getCheckpointProvider(this.transformConfig);
            return new ClientDataFrameIndexer(this.transformId, this.transformsConfigManager, checkpointProvider, new AtomicReference<IndexerState>(this.indexerState), this.initialPosition, this.client, this.auditor, this.initialStats, this.transformConfig, this.fieldMappings, this.progress, this.lastCheckpoint, this.nextCheckpoint, parentTask);
        }

        ClientDataFrameIndexerBuilder setClient(Client client) {
            this.client = client;
            return this;
        }

        ClientDataFrameIndexerBuilder setTransformsConfigManager(DataFrameTransformsConfigManager transformsConfigManager) {
            this.transformsConfigManager = transformsConfigManager;
            return this;
        }

        ClientDataFrameIndexerBuilder setTransformsCheckpointService(DataFrameTransformsCheckpointService transformsCheckpointService) {
            this.transformsCheckpointService = transformsCheckpointService;
            return this;
        }

        ClientDataFrameIndexerBuilder setTransformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        ClientDataFrameIndexerBuilder setAuditor(DataFrameAuditor auditor) {
            this.auditor = auditor;
            return this;
        }

        ClientDataFrameIndexerBuilder setFieldMappings(Map<String, String> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        ClientDataFrameIndexerBuilder setTransformConfig(DataFrameTransformConfig transformConfig) {
            this.transformConfig = transformConfig;
            return this;
        }

        DataFrameTransformConfig getTransformConfig() {
            return this.transformConfig;
        }

        ClientDataFrameIndexerBuilder setInitialStats(DataFrameIndexerTransformStats initialStats) {
            this.initialStats = initialStats;
            return this;
        }

        ClientDataFrameIndexerBuilder setIndexerState(IndexerState indexerState) {
            this.indexerState = indexerState;
            return this;
        }

        ClientDataFrameIndexerBuilder setInitialPosition(DataFrameIndexerPosition initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        ClientDataFrameIndexerBuilder setProgress(DataFrameTransformProgress progress) {
            this.progress = progress;
            return this;
        }

        ClientDataFrameIndexerBuilder setLastCheckpoint(DataFrameTransformCheckpoint lastCheckpoint) {
            this.lastCheckpoint = lastCheckpoint;
            return this;
        }

        ClientDataFrameIndexerBuilder setNextCheckpoint(DataFrameTransformCheckpoint nextCheckpoint) {
            this.nextCheckpoint = nextCheckpoint;
            return this;
        }
    }
}

