/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.transforms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.LatchedActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.dataframe.DataFrameMessages;
import org.elasticsearch.xpack.core.dataframe.action.StartDataFrameTransformTaskAction;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransform;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpoint;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformState;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformStoredDoc;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.dataframe.checkpoint.DataFrameTransformsCheckpointService;
import org.elasticsearch.xpack.dataframe.notifications.DataFrameAuditor;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameInternalIndex;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;
import org.elasticsearch.xpack.dataframe.transforms.DataFrameTransformTask;
import org.elasticsearch.xpack.dataframe.transforms.pivot.SchemaUtil;

public class DataFrameTransformPersistentTasksExecutor
extends PersistentTasksExecutor<DataFrameTransform> {
    private static final Logger logger = LogManager.getLogger(DataFrameTransformPersistentTasksExecutor.class);
    private static final int MARK_AS_FAILED_TIMEOUT_SEC = 90;
    private final Client client;
    private final DataFrameTransformsConfigManager transformsConfigManager;
    private final DataFrameTransformsCheckpointService dataFrameTransformsCheckpointService;
    private final SchedulerEngine schedulerEngine;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final DataFrameAuditor auditor;
    private volatile int numFailureRetries;

    public DataFrameTransformPersistentTasksExecutor(Client client, DataFrameTransformsConfigManager transformsConfigManager, DataFrameTransformsCheckpointService dataFrameTransformsCheckpointService, SchedulerEngine schedulerEngine, DataFrameAuditor auditor, ThreadPool threadPool, ClusterService clusterService, Settings settings) {
        super("data_frame/transforms", "data_frame_indexing");
        this.client = client;
        this.transformsConfigManager = transformsConfigManager;
        this.dataFrameTransformsCheckpointService = dataFrameTransformsCheckpointService;
        this.schedulerEngine = schedulerEngine;
        this.auditor = auditor;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.numFailureRetries = (Integer)DataFrameTransformTask.NUM_FAILURE_RETRIES_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DataFrameTransformTask.NUM_FAILURE_RETRIES_SETTING, this::setNumFailureRetries);
    }

    public PersistentTasksCustomMetaData.Assignment getAssignment(DataFrameTransform params, ClusterState clusterState) {
        List<String> unavailableIndices = DataFrameTransformPersistentTasksExecutor.verifyIndicesPrimaryShardsAreActive(clusterState);
        if (unavailableIndices.size() != 0) {
            String reason = "Not starting data frame transform [" + params.getId() + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
            logger.debug(reason);
            return new PersistentTasksCustomMetaData.Assignment(null, reason);
        }
        DiscoveryNode discoveryNode = this.selectLeastLoadedNode(clusterState, node -> node.isDataNode() && node.getVersion().onOrAfter(params.getVersion()));
        return discoveryNode == null ? NO_NODE_FOUND : new PersistentTasksCustomMetaData.Assignment(discoveryNode.getId(), "");
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(ClusterState clusterState) {
        IndexNameExpressionResolver resolver = new IndexNameExpressionResolver();
        String[] indices = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{".data-frame-internal-*"});
        ArrayList<String> unavailableIndices = new ArrayList<String>(indices.length);
        for (String index : indices) {
            IndexRoutingTable routingTable = clusterState.getRoutingTable().index(index);
            if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    protected void nodeOperation(AllocatedPersistentTask task, @Nullable DataFrameTransform params, PersistentTaskState state) {
        String transformId = params.getId();
        DataFrameTransformTask buildTask = (DataFrameTransformTask)task;
        DataFrameTransformTask.ClientDataFrameIndexerBuilder indexerBuilder = new DataFrameTransformTask.ClientDataFrameIndexerBuilder(transformId).setAuditor(this.auditor).setClient(this.client).setTransformsCheckpointService(this.dataFrameTransformsCheckpointService).setTransformsConfigManager(this.transformsConfigManager);
        SetOnce stateHolder = new SetOnce();
        ActionListener startTaskListener = ActionListener.wrap(response -> logger.info("Successfully completed and scheduled task in node operation"), failure -> logger.error("Failed to start task [" + transformId + "] in node operation", (Throwable)failure));
        ActionListener getTransformNextCheckpointListener = ActionListener.wrap(nextCheckpoint -> {
            if (nextCheckpoint.isEmpty()) {
                indexerBuilder.setInitialPosition(null);
                indexerBuilder.setProgress(null);
            } else {
                logger.trace("[{}] Loaded next checkpoint [{}] found, starting the task", (Object)transformId, (Object)nextCheckpoint.getCheckpoint());
                indexerBuilder.setNextCheckpoint((DataFrameTransformCheckpoint)nextCheckpoint);
            }
            long lastCheckpoint = ((DataFrameTransformState)stateHolder.get()).getCheckpoint();
            this.startTask(buildTask, indexerBuilder, lastCheckpoint, (ActionListener<StartDataFrameTransformTaskAction.Response>)startTaskListener);
        }, error -> {
            String msg = DataFrameMessages.getMessage((String)"Failed to load data frame transform checkpoint for transform [{0}]", (Object[])new Object[]{transformId});
            logger.error(msg, (Throwable)error);
            this.markAsFailed(buildTask, msg);
        });
        ActionListener getTransformLastCheckpointListener = ActionListener.wrap(lastCheckpoint -> {
            indexerBuilder.setLastCheckpoint((DataFrameTransformCheckpoint)lastCheckpoint);
            logger.trace("[{}] Loaded last checkpoint [{}], looking for next checkpoint", (Object)transformId, (Object)lastCheckpoint.getCheckpoint());
            this.transformsConfigManager.getTransformCheckpoint(transformId, lastCheckpoint.getCheckpoint() + 1L, (ActionListener<DataFrameTransformCheckpoint>)getTransformNextCheckpointListener);
        }, error -> {
            String msg = DataFrameMessages.getMessage((String)"Failed to load data frame transform checkpoint for transform [{0}]", (Object[])new Object[]{transformId});
            logger.error(msg, (Throwable)error);
            this.markAsFailed(buildTask, msg);
        });
        ActionListener transformStatsActionListener = ActionListener.wrap(stateAndStats -> {
            logger.trace("[{}] initializing state and stats: [{}]", (Object)transformId, (Object)stateAndStats.toString());
            indexerBuilder.setInitialStats(stateAndStats.getTransformStats()).setInitialPosition(stateAndStats.getTransformState().getPosition()).setProgress(stateAndStats.getTransformState().getProgress()).setIndexerState(DataFrameTransformPersistentTasksExecutor.currentIndexerState(stateAndStats.getTransformState()));
            logger.debug("[{}] Loading existing state: [{}], position [{}]", (Object)transformId, (Object)stateAndStats.getTransformState(), (Object)stateAndStats.getTransformState().getPosition());
            stateHolder.set((Object)stateAndStats.getTransformState());
            long lastCheckpoint = ((DataFrameTransformState)stateHolder.get()).getCheckpoint();
            if (lastCheckpoint == 0L) {
                logger.trace("[{}] No last checkpoint found, looking for next checkpoint", (Object)transformId);
                this.transformsConfigManager.getTransformCheckpoint(transformId, lastCheckpoint + 1L, (ActionListener<DataFrameTransformCheckpoint>)getTransformNextCheckpointListener);
            } else {
                logger.trace("[{}] Restore last checkpoint: [{}]", (Object)transformId, (Object)lastCheckpoint);
                this.transformsConfigManager.getTransformCheckpoint(transformId, lastCheckpoint, (ActionListener<DataFrameTransformCheckpoint>)getTransformLastCheckpointListener);
            }
        }, error -> {
            if (!(error instanceof ResourceNotFoundException)) {
                String msg = DataFrameMessages.getMessage((String)"Failed to load data frame transform state for transform [{0}]", (Object[])new Object[]{transformId});
                logger.error(msg, (Throwable)error);
                this.markAsFailed(buildTask, msg);
            }
            logger.trace("[{}] No stats found(new transform), starting the task", (Object)transformId);
            this.startTask(buildTask, indexerBuilder, null, (ActionListener<StartDataFrameTransformTaskAction.Response>)startTaskListener);
        });
        ActionListener getFieldMappingsListener = ActionListener.wrap(fieldMappings -> {
            indexerBuilder.setFieldMappings((Map<String, String>)fieldMappings);
            this.transformsConfigManager.getTransformStoredDoc(transformId, (ActionListener<DataFrameTransformStoredDoc>)transformStatsActionListener);
        }, error -> {
            String msg = DataFrameMessages.getMessage((String)"Failed to gather field mappings for index [{0}]", (Object[])new Object[]{indexerBuilder.getTransformConfig().getDestination().getIndex()});
            logger.error(msg, (Throwable)error);
            this.markAsFailed(buildTask, msg);
        });
        ActionListener getTransformConfigListener = ActionListener.wrap(config -> {
            if (config.isValid()) {
                indexerBuilder.setTransformConfig((DataFrameTransformConfig)config);
                SchemaUtil.getDestinationFieldMappings(this.client, config.getDestination().getIndex(), (ActionListener<Map<String, String>>)getFieldMappingsListener);
            } else {
                this.markAsFailed(buildTask, DataFrameMessages.getMessage((String)"Data frame transform configuration [{0}] has invalid elements", (Object[])new Object[]{transformId}));
            }
        }, error -> {
            String msg = DataFrameMessages.getMessage((String)"Failed to load data frame transform configuration for transform [{0}]", (Object[])new Object[]{transformId});
            logger.error(msg, (Throwable)error);
            this.markAsFailed(buildTask, msg);
        });
        ActionListener templateCheckListener = ActionListener.wrap(aVoid -> this.transformsConfigManager.getTransformConfiguration(transformId, (ActionListener<DataFrameTransformConfig>)getTransformConfigListener), error -> {
            String msg = "Failed to create internal index mappings";
            logger.error(msg, (Throwable)error);
            this.markAsFailed(buildTask, msg);
        });
        DataFrameInternalIndex.installLatestVersionedIndexTemplateIfRequired(this.clusterService, this.client, (ActionListener<Void>)templateCheckListener);
    }

    private static IndexerState currentIndexerState(DataFrameTransformState previousState) {
        if (previousState == null) {
            return IndexerState.STOPPED;
        }
        switch (previousState.getIndexerState()) {
            case STARTED: 
            case INDEXING: {
                return IndexerState.STARTED;
            }
        }
        return IndexerState.STOPPED;
    }

    private void markAsFailed(DataFrameTransformTask task, String reason) {
        CountDownLatch latch = new CountDownLatch(1);
        task.markAsFailed(reason, (ActionListener<Void>)new LatchedActionListener(ActionListener.wrap(nil -> {}, failure -> logger.error("Failed to set task [" + task.getTransformId() + "] to failed", (Throwable)failure)), latch));
        try {
            latch.await(90L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Timeout waiting for task [" + task.getTransformId() + "] to be marked as failed in cluster state", (Throwable)e);
        }
    }

    private void startTask(DataFrameTransformTask buildTask, DataFrameTransformTask.ClientDataFrameIndexerBuilder indexerBuilder, Long previousCheckpoint, ActionListener<StartDataFrameTransformTaskAction.Response> listener) {
        buildTask.initializeIndexer(indexerBuilder);
        buildTask.setNumFailureRetries(this.numFailureRetries).start(previousCheckpoint, false, listener);
    }

    private void setNumFailureRetries(int numFailureRetries) {
        this.numFailureRetries = numFailureRetries;
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<DataFrameTransform> persistentTask, Map<String, String> headers) {
        return new DataFrameTransformTask(id, type, action, parentTaskId, (DataFrameTransform)persistentTask.getParams(), (DataFrameTransformState)persistentTask.getState(), this.schedulerEngine, this.auditor, this.threadPool, headers);
    }
}

