/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.action.GetDataFrameTransformsStatsAction;

public class RestGetDataFrameTransformsStatsAction
extends BaseRestHandler {
    public RestGetDataFrameTransformsStatsAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, "/_data_frame/transforms/_stats", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_data_frame/transforms/{id}/_stats", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String id = restRequest.param(DataFrameField.ID.getPreferredName());
        GetDataFrameTransformsStatsAction.Request request = new GetDataFrameTransformsStatsAction.Request(id);
        request.setAllowNoMatch(restRequest.paramAsBoolean(DataFrameField.ALLOW_NO_MATCH.getPreferredName(), true));
        if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
            request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
        }
        return channel -> client.execute((ActionType)GetDataFrameTransformsStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    public String getName() {
        return "data_frame_get_transforms_stats_action";
    }
}

