/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessage;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameIndexerTransformStats;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformProgress;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformState;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformStoredDoc;
import org.elasticsearch.xpack.core.dataframe.transforms.DestConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.SourceConfig;

public final class DataFrameInternalIndex {
    public static final String INDEX_VERSION = "2";
    public static final String INDEX_PATTERN = ".data-frame-internal-";
    public static final String LATEST_INDEX_VERSIONED_NAME = ".data-frame-internal-2";
    public static final String LATEST_INDEX_NAME = ".data-frame-internal-2";
    public static final String INDEX_NAME_PATTERN = ".data-frame-internal-*";
    public static final String AUDIT_TEMPLATE_VERSION = "1";
    public static final String AUDIT_INDEX_PREFIX = ".data-frame-notifications-";
    public static final String AUDIT_INDEX = ".data-frame-notifications-1";
    public static final String DYNAMIC = "dynamic";
    public static final String PROPERTIES = "properties";
    public static final String TYPE = "type";
    public static final String ENABLED = "enabled";
    public static final String DATE = "date";
    public static final String TEXT = "text";
    public static final String FIELDS = "fields";
    public static final String RAW = "raw";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String LONG = "long";
    public static final String KEYWORD = "keyword";

    public static IndexTemplateMetaData getIndexTemplateMetaData() throws IOException {
        IndexTemplateMetaData dataFrameTemplate = IndexTemplateMetaData.builder((String)".data-frame-internal-2").patterns(Collections.singletonList(".data-frame-internal-2")).version(Integer.valueOf(Version.CURRENT.id)).settings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1")).putMapping("_doc", Strings.toString((XContentBuilder)DataFrameInternalIndex.mappings())).build();
        return dataFrameTemplate;
    }

    public static IndexTemplateMetaData getAuditIndexTemplateMetaData() throws IOException {
        IndexTemplateMetaData dataFrameTemplate = IndexTemplateMetaData.builder((String)AUDIT_INDEX).patterns(Collections.singletonList(".data-frame-notifications-*")).version(Integer.valueOf(Version.CURRENT.id)).settings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1")).putMapping("_doc", Strings.toString((XContentBuilder)DataFrameInternalIndex.auditMappings())).build();
        return dataFrameTemplate;
    }

    private static XContentBuilder auditMappings() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        builder.startObject("_doc");
        DataFrameInternalIndex.addMetaInformation(builder);
        builder.field(DYNAMIC, "false");
        builder.startObject(PROPERTIES).startObject("transform_id").field(TYPE, KEYWORD).endObject().startObject(AbstractAuditMessage.LEVEL.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AbstractAuditMessage.MESSAGE.getPreferredName()).field(TYPE, TEXT).startObject(FIELDS).startObject(RAW).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(AbstractAuditMessage.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject().startObject(AbstractAuditMessage.NODE_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().endObject();
        return builder;
    }

    public static XContentBuilder mappings() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        return DataFrameInternalIndex.mappings(builder);
    }

    public static XContentBuilder mappings(XContentBuilder builder) throws IOException {
        builder.startObject();
        builder.startObject("_doc");
        DataFrameInternalIndex.addMetaInformation(builder);
        builder.field(DYNAMIC, "false");
        builder.startObject(PROPERTIES);
        builder.startObject(DataFrameField.INDEX_DOC_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject();
        DataFrameInternalIndex.addDataFrameTransformsConfigMappings(builder);
        DataFrameInternalIndex.addDataFrameTransformStoredDocMappings(builder);
        DataFrameInternalIndex.addDataFrameCheckpointMappings(builder);
        builder.endObject();
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static XContentBuilder addDataFrameTransformStoredDocMappings(XContentBuilder builder) throws IOException {
        return builder.startObject(DataFrameTransformStoredDoc.STATE_FIELD.getPreferredName()).startObject(PROPERTIES).startObject(DataFrameTransformState.TASK_STATE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DataFrameTransformState.INDEXER_STATE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DataFrameTransformState.CURRENT_POSITION.getPreferredName()).field(ENABLED, false).endObject().startObject(DataFrameTransformState.CHECKPOINT.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameTransformState.REASON.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DataFrameTransformState.PROGRESS.getPreferredName()).startObject(PROPERTIES).startObject(DataFrameTransformProgress.TOTAL_DOCS.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameTransformProgress.DOCS_REMAINING.getPreferredName()).field(TYPE, LONG).endObject().startObject("percent_complete").field(TYPE, FLOAT).endObject().startObject(DataFrameTransformProgress.DOCS_INDEXED.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameTransformProgress.DOCS_PROCESSED.getPreferredName()).field(TYPE, LONG).endObject().endObject().endObject().endObject().endObject().startObject(DataFrameField.STATS_FIELD.getPreferredName()).startObject(PROPERTIES).startObject(DataFrameIndexerTransformStats.NUM_PAGES.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameIndexerTransformStats.NUM_INPUT_DOCUMENTS.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameIndexerTransformStats.NUM_OUTPUT_DOCUMENTS.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameIndexerTransformStats.NUM_INVOCATIONS.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameIndexerTransformStats.INDEX_TIME_IN_MS.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameIndexerTransformStats.SEARCH_TIME_IN_MS.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameIndexerTransformStats.INDEX_TOTAL.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameIndexerTransformStats.SEARCH_TOTAL.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameIndexerTransformStats.SEARCH_FAILURES.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameIndexerTransformStats.INDEX_FAILURES.getPreferredName()).field(TYPE, LONG).endObject().startObject(DataFrameIndexerTransformStats.EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(DataFrameIndexerTransformStats.EXPONENTIAL_AVG_DOCUMENTS_INDEXED.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(DataFrameIndexerTransformStats.EXPONENTIAL_AVG_DOCUMENTS_PROCESSED.getPreferredName()).field(TYPE, DOUBLE).endObject().endObject().endObject();
    }

    public static XContentBuilder addDataFrameTransformsConfigMappings(XContentBuilder builder) throws IOException {
        return builder.startObject(DataFrameField.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DataFrameField.SOURCE.getPreferredName()).startObject(PROPERTIES).startObject(SourceConfig.INDEX.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(SourceConfig.QUERY.getPreferredName()).field(ENABLED, "false").endObject().endObject().endObject().startObject(DataFrameField.DESTINATION.getPreferredName()).startObject(PROPERTIES).startObject(DestConfig.INDEX.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(DataFrameField.DESCRIPTION.getPreferredName()).field(TYPE, TEXT).endObject().startObject(DataFrameField.VERSION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(DataFrameField.CREATE_TIME.getPreferredName()).field(TYPE, DATE).endObject();
    }

    private static XContentBuilder addDataFrameCheckpointMappings(XContentBuilder builder) throws IOException {
        return builder.startObject(DataFrameField.TIMESTAMP_MILLIS.getPreferredName()).field(TYPE, DATE).endObject().startObject(DataFrameField.TIME_UPPER_BOUND_MILLIS.getPreferredName()).field(TYPE, DATE).endObject();
    }

    private static XContentBuilder addMetaInformation(XContentBuilder builder) throws IOException {
        return builder.startObject("_meta").field("version", (ToXContent)Version.CURRENT).endObject();
    }

    public static boolean haveLatestVersionedIndexTemplate(ClusterState state) {
        return state.getMetaData().getTemplates().containsKey((Object)".data-frame-internal-2");
    }

    public static void installLatestVersionedIndexTemplateIfRequired(ClusterService clusterService, Client client, ActionListener<Void> listener) {
        if (DataFrameInternalIndex.haveLatestVersionedIndexTemplate(clusterService.state())) {
            listener.onResponse(null);
            return;
        }
        try {
            IndexTemplateMetaData indexTemplateMetaData = DataFrameInternalIndex.getIndexTemplateMetaData();
            BytesArray jsonMappings = new BytesArray(((CompressedXContent)indexTemplateMetaData.mappings().get((Object)"_doc")).uncompressed());
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(".data-frame-internal-2").patterns(indexTemplateMetaData.patterns()).version(indexTemplateMetaData.version()).settings(indexTemplateMetaData.settings()).mapping("_doc", (Map)XContentHelper.convertToMap((BytesReference)jsonMappings, (boolean)true, (XContentType)XContentType.JSON).v2());
            ActionListener innerListener = ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0));
            ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"data_frame", (ActionRequest)request, (ActionListener)innerListener, (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).putTemplate(arg_0, arg_1));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    private DataFrameInternalIndex() {
    }
}

