/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.checkpoint;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpoint;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.TimeSyncConfig;
import org.elasticsearch.xpack.dataframe.checkpoint.DefaultCheckpointProvider;
import org.elasticsearch.xpack.dataframe.notifications.DataFrameAuditor;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;

public class TimeBasedCheckpointProvider
extends DefaultCheckpointProvider {
    private static final Logger logger = LogManager.getLogger(TimeBasedCheckpointProvider.class);
    private final TimeSyncConfig timeSyncConfig;

    TimeBasedCheckpointProvider(Client client, DataFrameTransformsConfigManager dataFrameTransformsConfigManager, DataFrameAuditor dataFrameAuditor, DataFrameTransformConfig transformConfig) {
        super(client, dataFrameTransformsConfigManager, dataFrameAuditor, transformConfig);
        this.timeSyncConfig = (TimeSyncConfig)transformConfig.getSyncConfig();
    }

    @Override
    public void sourceHasChanged(DataFrameTransformCheckpoint lastCheckpoint, ActionListener<Boolean> listener) {
        long timestamp = this.getTime();
        SearchRequest searchRequest = new SearchRequest(this.transformConfig.getSource().getIndex()).allowPartialSearchResults(false).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().size(0).trackTotalHitsUpTo(1);
        QueryBuilder queryBuilder = this.transformConfig.getSource().getQueryConfig().getQuery();
        BoolQueryBuilder filteredQuery = new BoolQueryBuilder().filter(queryBuilder).filter((QueryBuilder)new RangeQueryBuilder(this.timeSyncConfig.getField()).gte((Object)lastCheckpoint.getTimeUpperBound()).lt((Object)(timestamp - this.timeSyncConfig.getDelay().millis())).format("epoch_millis"));
        sourceBuilder.query((QueryBuilder)filteredQuery);
        searchRequest.source(sourceBuilder);
        logger.trace("query for changes based on time: {}", (Object)sourceBuilder);
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"data_frame", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)(r.getHits().getTotalHits().value > 0L ? 1 : 0)), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void createNextCheckpoint(DataFrameTransformCheckpoint lastCheckpoint, ActionListener<DataFrameTransformCheckpoint> listener) {
        long timestamp = this.getTime();
        long checkpoint = lastCheckpoint != null ? lastCheckpoint.getCheckpoint() + 1L : 1L;
        long timeUpperBound = timestamp - this.timeSyncConfig.getDelay().millis();
        this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)ActionListener.wrap(checkpointsByIndex -> listener.onResponse((Object)new DataFrameTransformCheckpoint(this.transformConfig.getId(), timestamp, checkpoint, checkpointsByIndex, Long.valueOf(timeUpperBound))), arg_0 -> listener.onFailure(arg_0)));
    }

    long getTime() {
        return System.currentTimeMillis();
    }
}

