/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.checkpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameIndexerPosition;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpoint;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpointStats;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpointingInfo;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformProgress;
import org.elasticsearch.xpack.dataframe.checkpoint.CheckpointException;
import org.elasticsearch.xpack.dataframe.checkpoint.CheckpointProvider;
import org.elasticsearch.xpack.dataframe.notifications.DataFrameAuditor;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;

public class DefaultCheckpointProvider
implements CheckpointProvider {
    private static final int AUDIT_CONCRETED_SOURCE_INDEX_CHANGES = 10;
    private static final Logger logger = LogManager.getLogger(DefaultCheckpointProvider.class);
    protected final Client client;
    protected final DataFrameTransformsConfigManager dataFrameTransformsConfigManager;
    protected final DataFrameAuditor dataFrameAuditor;
    protected final DataFrameTransformConfig transformConfig;

    public DefaultCheckpointProvider(Client client, DataFrameTransformsConfigManager dataFrameTransformsConfigManager, DataFrameAuditor dataFrameAuditor, DataFrameTransformConfig transformConfig) {
        this.client = client;
        this.dataFrameTransformsConfigManager = dataFrameTransformsConfigManager;
        this.dataFrameAuditor = dataFrameAuditor;
        this.transformConfig = transformConfig;
    }

    @Override
    public void sourceHasChanged(DataFrameTransformCheckpoint lastCheckpoint, ActionListener<Boolean> listener) {
        listener.onResponse((Object)false);
    }

    @Override
    public void createNextCheckpoint(DataFrameTransformCheckpoint lastCheckpoint, ActionListener<DataFrameTransformCheckpoint> listener) {
        long timestamp = System.currentTimeMillis();
        long checkpoint = lastCheckpoint != null ? lastCheckpoint.getCheckpoint() + 1L : 1L;
        this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)ActionListener.wrap(checkpointsByIndex -> {
            this.reportSourceIndexChanges(lastCheckpoint != null ? lastCheckpoint.getIndicesCheckpoints().keySet() : Collections.emptySet(), checkpointsByIndex.keySet());
            listener.onResponse((Object)new DataFrameTransformCheckpoint(this.transformConfig.getId(), timestamp, checkpoint, checkpointsByIndex, Long.valueOf(0L)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected void getIndexCheckpoints(ActionListener<Map<String, long[]>> listener) {
        GetIndexRequest getIndexRequest = (GetIndexRequest)((GetIndexRequest)new GetIndexRequest().indices(this.transformConfig.getSource().getIndex())).features(new GetIndexRequest.Feature[0]).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"data_frame", (Client)this.client, (ActionType)GetIndexAction.INSTANCE, (ActionRequest)getIndexRequest, (ActionListener)ActionListener.wrap(getIndexResponse -> {
            HashSet<String> userIndices = getIndexResponse.getIndices() != null ? new HashSet<String>(Arrays.asList(getIndexResponse.getIndices())) : Collections.emptySet();
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"data_frame", (ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)((IndicesStatsRequest)((IndicesStatsRequest)new IndicesStatsRequest().indices(this.transformConfig.getSource().getIndex())).clear().indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN)), (ActionListener)ActionListener.wrap(response -> {
                if (response.getFailedShards() != 0) {
                    listener.onFailure((Exception)((Object)new CheckpointException("Source has [" + response.getFailedShards() + "] failed shards", new Object[0])));
                    return;
                }
                listener.onResponse(DefaultCheckpointProvider.extractIndexCheckPoints(response.getShards(), userIndices));
            }, e -> listener.onFailure((Exception)((Object)new CheckpointException("Failed to create checkpoint", (Throwable)e, new Object[0])))));
        }, e -> listener.onFailure((Exception)((Object)new CheckpointException("Failed to create checkpoint", (Throwable)e, new Object[0])))));
    }

    static Map<String, long[]> extractIndexCheckPoints(ShardStats[] shards, Set<String> userIndices) {
        TreeMap<String, TreeMap> checkpointsByIndex = new TreeMap<String, TreeMap>();
        for (ShardStats shard : shards) {
            long globalCheckpoint;
            String indexName2 = shard.getShardRouting().getIndexName();
            if (!userIndices.contains(indexName2)) continue;
            long l = globalCheckpoint = shard.getSeqNoStats() == null ? -1L : shard.getSeqNoStats().getGlobalCheckpoint();
            if (checkpointsByIndex.containsKey(indexName2)) {
                TreeMap checkpoints2 = (TreeMap)checkpointsByIndex.get(indexName2);
                if (checkpoints2.containsKey(shard.getShardRouting().getId())) {
                    if ((Long)checkpoints2.get(shard.getShardRouting().getId()) == globalCheckpoint) continue;
                    throw new CheckpointException("Global checkpoints mismatch for index [" + indexName2 + "] between shards of id [" + shard.getShardRouting().getId() + "]", new Object[0]);
                }
                checkpoints2.put(shard.getShardRouting().getId(), globalCheckpoint);
                continue;
            }
            checkpointsByIndex.put(indexName2, new TreeMap());
            ((TreeMap)checkpointsByIndex.get(indexName2)).put(shard.getShardRouting().getId(), globalCheckpoint);
        }
        if (logger.isDebugEnabled()) {
            HashSet<String> userIndicesClone = new HashSet<String>(userIndices);
            userIndicesClone.removeAll(checkpointsByIndex.keySet());
            if (!userIndicesClone.isEmpty()) {
                logger.debug("Original set of user indices contained more indexes [{}]", userIndicesClone);
            }
        }
        TreeMap<String, long[]> checkpointsByIndexReduced = new TreeMap<String, long[]>();
        checkpointsByIndex.forEach((indexName, checkpoints) -> checkpointsByIndexReduced.put((String)indexName, checkpoints.values().stream().mapToLong(l -> l).toArray()));
        return checkpointsByIndexReduced;
    }

    @Override
    public void getCheckpointingInfo(DataFrameTransformCheckpoint lastCheckpoint, DataFrameTransformCheckpoint nextCheckpoint, DataFrameIndexerPosition nextCheckpointPosition, DataFrameTransformProgress nextCheckpointProgress, ActionListener<DataFrameTransformCheckpointingInfo> listener) {
        DataFrameTransformCheckpointingInfoBuilder checkpointingInfoBuilder = new DataFrameTransformCheckpointingInfoBuilder();
        checkpointingInfoBuilder.setLastCheckpoint(lastCheckpoint).setNextCheckpoint(nextCheckpoint).setNextCheckpointPosition(nextCheckpointPosition).setNextCheckpointProgress(nextCheckpointProgress);
        long timestamp = System.currentTimeMillis();
        this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)ActionListener.wrap(checkpointsByIndex -> {
            checkpointingInfoBuilder.setSourceCheckpoint(new DataFrameTransformCheckpoint(this.transformConfig.getId(), timestamp, -1L, checkpointsByIndex, Long.valueOf(0L)));
            listener.onResponse((Object)checkpointingInfoBuilder.build());
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void getCheckpointingInfo(long lastCheckpointNumber, DataFrameIndexerPosition nextCheckpointPosition, DataFrameTransformProgress nextCheckpointProgress, ActionListener<DataFrameTransformCheckpointingInfo> listener) {
        DataFrameTransformCheckpointingInfoBuilder checkpointingInfoBuilder = new DataFrameTransformCheckpointingInfoBuilder();
        checkpointingInfoBuilder.setNextCheckpointPosition(nextCheckpointPosition).setNextCheckpointProgress(nextCheckpointProgress);
        long timestamp = System.currentTimeMillis();
        ActionListener checkpointsByIndexListener = ActionListener.wrap(checkpointsByIndex -> {
            checkpointingInfoBuilder.setSourceCheckpoint(new DataFrameTransformCheckpoint(this.transformConfig.getId(), timestamp, -1L, checkpointsByIndex, Long.valueOf(0L)));
            listener.onResponse((Object)checkpointingInfoBuilder.build());
        }, e -> {
            logger.debug(() -> new ParameterizedMessage("Failed to retrieve source checkpoint for data frame [{}]", (Object)this.transformConfig.getId()), (Throwable)e);
            listener.onFailure((Exception)((Object)new CheckpointException("Failure during source checkpoint info retrieval", (Throwable)e, new Object[0])));
        });
        ActionListener nextCheckpointListener = ActionListener.wrap(nextCheckpointObj -> {
            checkpointingInfoBuilder.setNextCheckpoint((DataFrameTransformCheckpoint)nextCheckpointObj);
            this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)checkpointsByIndexListener);
        }, e -> {
            logger.debug(() -> new ParameterizedMessage("Failed to retrieve next checkpoint [{}] for data frame [{}]", (Object)(lastCheckpointNumber + 1L), (Object)this.transformConfig.getId()), (Throwable)e);
            listener.onFailure((Exception)((Object)new CheckpointException("Failure during next checkpoint info retrieval", (Throwable)e, new Object[0])));
        });
        ActionListener lastCheckpointListener = ActionListener.wrap(lastCheckpointObj -> {
            checkpointingInfoBuilder.lastCheckpoint = lastCheckpointObj;
            this.dataFrameTransformsConfigManager.getTransformCheckpoint(this.transformConfig.getId(), lastCheckpointNumber + 1L, (ActionListener<DataFrameTransformCheckpoint>)nextCheckpointListener);
        }, e -> {
            logger.debug(() -> new ParameterizedMessage("Failed to retrieve last checkpoint [{}] for data frame [{}]", (Object)lastCheckpointNumber, (Object)this.transformConfig.getId()), (Throwable)e);
            listener.onFailure((Exception)((Object)new CheckpointException("Failure during last checkpoint info retrieval", (Throwable)e, new Object[0])));
        });
        if (lastCheckpointNumber != 0L) {
            this.dataFrameTransformsConfigManager.getTransformCheckpoint(this.transformConfig.getId(), lastCheckpointNumber, (ActionListener<DataFrameTransformCheckpoint>)lastCheckpointListener);
        } else {
            this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)checkpointsByIndexListener);
        }
    }

    void reportSourceIndexChanges(Set<String> lastSourceIndexes, Set<String> newSourceIndexes) {
        if (newSourceIndexes.isEmpty() && !lastSourceIndexes.isEmpty()) {
            String message = "Source did not resolve to any open indexes";
            logger.warn("{} for transform [{}]", (Object)message, (Object)this.transformConfig.getId());
            this.dataFrameAuditor.warning(this.transformConfig.getId(), message);
        } else {
            Set removedIndexes = Sets.difference(lastSourceIndexes, newSourceIndexes);
            Set addedIndexes = Sets.difference(newSourceIndexes, lastSourceIndexes);
            if (removedIndexes.size() + addedIndexes.size() > 10) {
                String message = "Source index resolve found more than 10 changes, [" + removedIndexes.size() + "] removed indexes, [" + addedIndexes.size() + "] new indexes";
                logger.debug("{} for transform [{}]", (Object)message, (Object)this.transformConfig.getId());
                this.dataFrameAuditor.info(this.transformConfig.getId(), message);
            } else if (removedIndexes.size() + addedIndexes.size() > 0) {
                String message = "Source index resolve found changes, removedIndexes: " + removedIndexes + ", new indexes: " + addedIndexes;
                logger.debug("{} for transform [{}]", (Object)message, (Object)this.transformConfig.getId());
                this.dataFrameAuditor.info(this.transformConfig.getId(), message);
            }
        }
    }

    private static class DataFrameTransformCheckpointingInfoBuilder {
        private DataFrameIndexerPosition nextCheckpointPosition;
        private DataFrameTransformProgress nextCheckpointProgress;
        private DataFrameTransformCheckpoint lastCheckpoint;
        private DataFrameTransformCheckpoint nextCheckpoint;
        private DataFrameTransformCheckpoint sourceCheckpoint;

        DataFrameTransformCheckpointingInfoBuilder() {
        }

        DataFrameTransformCheckpointingInfo build() {
            if (this.lastCheckpoint == null) {
                this.lastCheckpoint = DataFrameTransformCheckpoint.EMPTY;
            }
            if (this.nextCheckpoint == null) {
                this.nextCheckpoint = DataFrameTransformCheckpoint.EMPTY;
            }
            if (this.sourceCheckpoint == null) {
                this.sourceCheckpoint = DataFrameTransformCheckpoint.EMPTY;
            }
            long lastCheckpointNumber = this.lastCheckpoint.getCheckpoint() > 0L ? this.lastCheckpoint.getCheckpoint() : 0L;
            long nextCheckpointNumber = this.nextCheckpoint.getCheckpoint() > 0L ? this.nextCheckpoint.getCheckpoint() : 0L;
            return new DataFrameTransformCheckpointingInfo(new DataFrameTransformCheckpointStats(lastCheckpointNumber, null, null, this.lastCheckpoint.getTimestamp(), this.lastCheckpoint.getTimeUpperBound()), new DataFrameTransformCheckpointStats(nextCheckpointNumber, this.nextCheckpointPosition, this.nextCheckpointProgress, this.nextCheckpoint.getTimestamp(), this.nextCheckpoint.getTimeUpperBound()), DataFrameTransformCheckpoint.getBehind((DataFrameTransformCheckpoint)this.lastCheckpoint, (DataFrameTransformCheckpoint)this.sourceCheckpoint));
        }

        public DataFrameTransformCheckpointingInfoBuilder setLastCheckpoint(DataFrameTransformCheckpoint lastCheckpoint) {
            this.lastCheckpoint = lastCheckpoint;
            return this;
        }

        public DataFrameTransformCheckpointingInfoBuilder setNextCheckpoint(DataFrameTransformCheckpoint nextCheckpoint) {
            this.nextCheckpoint = nextCheckpoint;
            return this;
        }

        public DataFrameTransformCheckpointingInfoBuilder setSourceCheckpoint(DataFrameTransformCheckpoint sourceCheckpoint) {
            this.sourceCheckpoint = sourceCheckpoint;
            return this;
        }

        public DataFrameTransformCheckpointingInfoBuilder setNextCheckpointProgress(DataFrameTransformProgress nextCheckpointProgress) {
            this.nextCheckpointProgress = nextCheckpointProgress;
            return this;
        }

        public DataFrameTransformCheckpointingInfoBuilder setNextCheckpointPosition(DataFrameIndexerPosition nextCheckpointPosition) {
            this.nextCheckpointPosition = nextCheckpointPosition;
            return this;
        }
    }
}

