/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.action;

import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.dataframe.action.StartDataFrameTransformTaskAction;
import org.elasticsearch.xpack.dataframe.transforms.DataFrameTransformTask;

public class TransportStartDataFrameTransformTaskAction
extends TransportTasksAction<DataFrameTransformTask, StartDataFrameTransformTaskAction.Request, StartDataFrameTransformTaskAction.Response, StartDataFrameTransformTaskAction.Response> {
    private final XPackLicenseState licenseState;

    @Inject
    public TransportStartDataFrameTransformTaskAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, XPackLicenseState licenseState) {
        super("cluster:admin/data_frame/start_task", clusterService, transportService, actionFilters, StartDataFrameTransformTaskAction.Request::new, StartDataFrameTransformTaskAction.Response::new, StartDataFrameTransformTaskAction.Response::new, "same");
        this.licenseState = licenseState;
    }

    protected void doExecute(Task task, StartDataFrameTransformTaskAction.Request request, ActionListener<StartDataFrameTransformTaskAction.Response> listener) {
        if (!this.licenseState.isDataFrameAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"data_frame"));
            return;
        }
        super.doExecute(task, (BaseTasksRequest)request, listener);
    }

    protected void taskOperation(StartDataFrameTransformTaskAction.Request request, DataFrameTransformTask transformTask, ActionListener<StartDataFrameTransformTaskAction.Response> listener) {
        if (transformTask.getTransformId().equals(request.getId())) {
            transformTask.start(null, request.isForce(), listener);
        } else {
            listener.onFailure((Exception)new RuntimeException("ID of data frame transform task [" + transformTask.getTransformId() + "] does not match request's ID [" + request.getId() + "]"));
        }
    }

    protected StartDataFrameTransformTaskAction.Response newResponse(StartDataFrameTransformTaskAction.Request request, List<StartDataFrameTransformTaskAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
        }
        if (!failedNodeExceptions.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
        }
        if (tasks.size() == 0) {
            throw new ResourceNotFoundException("Task for data frame transform [" + request.getId() + "] not found", new Object[0]);
        }
        assert (tasks.size() == 1);
        boolean allStarted = tasks.stream().allMatch(StartDataFrameTransformTaskAction.Response::isStarted);
        return new StartDataFrameTransformTaskAction.Response(allStarted);
    }
}

